/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.ui.codereview.avatar;

import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/collaboration/ui/codereview/avatar/AvatarIconWithOutline;", "Ljavax/swing/Icon;", "avatarIcon", "outlineColor", "Ljava/awt/Color;", "<init>", "(Ljavax/swing/Icon;Ljava/awt/Color;)V", "getIconWidth", "", "getIconHeight", "paintIcon", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "y", "intellij.platform.collaborationTools"})
final class AvatarIconWithOutline
implements Icon {
    @NotNull
    private final Icon avatarIcon;
    @NotNull
    private final Color outlineColor;

    public AvatarIconWithOutline(@NotNull Icon avatarIcon, @NotNull Color outlineColor) {
        Intrinsics.checkNotNullParameter((Object)avatarIcon, (String)"avatarIcon");
        Intrinsics.checkNotNullParameter((Object)outlineColor, (String)"outlineColor");
        this.avatarIcon = avatarIcon;
        this.outlineColor = outlineColor;
    }

    @Override
    public int getIconWidth() {
        return this.avatarIcon.getIconWidth() + 2 * JBUI.scale((int)3);
    }

    @Override
    public int getIconHeight() {
        return this.avatarIcon.getIconHeight() + 2 * JBUI.scale((int)3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(@NotNull Component c, @NotNull Graphics g, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.translate(x, y);
        float width = this.getIconWidth();
        float height = this.getIconHeight();
        int innerIconOffset = JBUI.scale((int)3);
        float outlineThickness = JBUIScale.scale((float)2.0f);
        try {
            GraphicsUtil.setupRoundedBorderAntialiasing((Graphics)g2d);
            Path2D.Float border = new Path2D.Float(0);
            border.append(new Ellipse2D.Float(0.0f, 0.0f, width, height), false);
            float innerWidth = width - outlineThickness * (float)2;
            float innerHeight = height - outlineThickness * (float)2;
            border.append(new Ellipse2D.Float(outlineThickness, outlineThickness, innerWidth, innerHeight), false);
            g2d.setColor(this.outlineColor);
            g2d.fill(border);
            this.avatarIcon.paintIcon(c, g2d, innerIconOffset, innerIconOffset);
        }
        finally {
            g2d.dispose();
        }
    }
}

