/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model.schema;

import java.util.Objects;
import java.util.Optional;
import org.openapitools.openapidiff.core.model.BackwardIncompatibleProp;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.DiffResult;

public class ChangedReadOnly
implements Changed {
    private final DiffContext context;
    private final boolean oldValue;
    private final boolean newValue;

    public ChangedReadOnly(Boolean oldValue, Boolean newValue, DiffContext context) {
        this.context = context;
        this.oldValue = Optional.ofNullable(oldValue).orElse(false);
        this.newValue = Optional.ofNullable(newValue).orElse(false);
    }

    @Override
    public DiffResult isChanged() {
        if (Objects.equals(this.oldValue, this.newValue)) {
            return DiffResult.NO_CHANGES;
        }
        if (this.context.isResponse()) {
            return DiffResult.COMPATIBLE;
        }
        if (this.context.isRequest()) {
            if (Boolean.TRUE.equals(this.newValue) ? BackwardIncompatibleProp.REQUEST_READONLY_INCREASED.enabled(this.context, new Object[0]) : this.context.isRequired() != false && BackwardIncompatibleProp.REQUEST_READONLY_REQUIRED_DECREASED.enabled(this.context, new Object[0])) {
                return DiffResult.INCOMPATIBLE;
            }
            return DiffResult.COMPATIBLE;
        }
        return DiffResult.UNKNOWN;
    }
}

