/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.ingest.Processor;
import org.opensearch.client.opensearch.ingest.ProcessorBase;
import org.opensearch.client.opensearch.ingest.ProcessorVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class JoinProcessor
extends ProcessorBase
implements ProcessorVariant,
ToCopyableBuilder<Builder, JoinProcessor> {
    @Nonnull
    private final String field;
    @Nonnull
    private final String separator;
    @Nullable
    private final String targetField;
    public static final JsonpDeserializer<JoinProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, JoinProcessor::setupJoinProcessorDeserializer);

    private JoinProcessor(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.separator = ApiTypeHelper.requireNonNull(builder.separator, this, "separator");
        this.targetField = builder.targetField;
    }

    public static JoinProcessor of(Function<Builder, ObjectBuilder<JoinProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Join;
    }

    @Nonnull
    public final String field() {
        return this.field;
    }

    @Nonnull
    public final String separator() {
        return this.separator;
    }

    @Nullable
    public final String targetField() {
        return this.targetField;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        generator.writeKey("separator");
        generator.write(this.separator);
        if (this.targetField != null) {
            generator.writeKey("target_field");
            generator.write(this.targetField);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupJoinProcessorDeserializer(ObjectDeserializer<Builder> op) {
        JoinProcessor.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::separator, JsonpDeserializer.stringDeserializer(), "separator");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.field.hashCode();
        result = 31 * result + this.separator.hashCode();
        result = 31 * result + Objects.hashCode(this.targetField);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinProcessor other = (JoinProcessor)o;
        return this.field.equals(other.field) && this.separator.equals(other.separator) && Objects.equals(this.targetField, other.targetField);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, JoinProcessor> {
        private String field;
        private String separator;
        @Nullable
        private String targetField;

        public Builder() {
        }

        private Builder(JoinProcessor o) {
            super(o);
            this.field = o.field;
            this.separator = o.separator;
            this.targetField = o.targetField;
        }

        private Builder(Builder o) {
            super(o);
            this.field = o.field;
            this.separator = o.separator;
            this.targetField = o.targetField;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder separator(String value) {
            this.separator = value;
            return this;
        }

        @Nonnull
        public final Builder targetField(@Nullable String value) {
            this.targetField = value;
            return this;
        }

        @Override
        @Nonnull
        public JoinProcessor build() {
            this._checkSingleUse();
            return new JoinProcessor(this);
        }
    }
}

