/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DeprecatedAttributes;
import org.apache.commons.cli.Option;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.cli.ToolRuntime;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudHttp2SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.impl.JsonMapResponseParser;
import org.apache.solr.client.solrj.impl.NoOpResponseParser;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.NamedList;
import org.noggit.CharArr;
import org.noggit.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteTool
extends ToolBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public DeleteTool(ToolRuntime runtime) {
        super(runtime);
    }

    @Override
    public String getName() {
        return "delete";
    }

    @Override
    public String getHeader() {
        return "Deletes a core or collection depending on whether Solr is running in standalone (core) or SolrCloud mode (collection). If you're deleting a collection in SolrCloud mode, the default behavior is to also delete the configuration directory from Zookeeper so long as it is not being used by another collection.\n You can override this behavior by passing --delete-config false when running this command.\n\nList of options:";
    }

    @Override
    public List<Option> getOptions() {
        return List.of(Option.builder((String)"c").longOpt("name").argName("NAME").hasArg().required(true).desc("Name of the core / collection to delete.").build(), Option.builder((String)"d").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("9.8").setDescription("Use --delete-config instead").get()).hasArg().argName("true|false").required(false).desc("Flag to indicate if the underlying configuration directory for a collection should also be deleted; default is true.").build(), Option.builder().longOpt("delete-config").hasArg().argName("true|false").required(false).desc("Flag to indicate if the underlying configuration directory for a collection should also be deleted; default is true.").build(), Option.builder().longOpt("deleteConfig").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("9.7").setDescription("Use --delete-config instead").get()).hasArg().argName("true|false").required(false).desc("Flag to indicate if the underlying configuration directory for a collection should also be deleted; default is true.").build(), Option.builder().longOpt("force-delete-config").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("9.8").setDescription("Use --force instead").get()).required(false).desc("Skip safety checks when deleting the configuration directory used by a collection.").build(), Option.builder((String)"p").longOpt("port").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("9.7").setDescription("Use --solr-url instead").get()).argName("PORT").hasArg().required(false).desc("Port of a local Solr instance where you want to create the new core.").build(), Option.builder().longOpt("forceDeleteConfig").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("9.7").setDescription("Use --force instead").get()).required(false).desc("Skip safety checks when deleting the configuration directory used by a collection.").build(), Option.builder((String)"f").longOpt("force").required(false).desc("Skip safety checks when deleting the configuration directory used by a collection.").build(), SolrCLI.OPTION_SOLRURL, SolrCLI.OPTION_SOLRURL_DEPRECATED, SolrCLI.OPTION_SOLRURL_DEPRECATED_SHORT, SolrCLI.OPTION_ZKHOST, SolrCLI.OPTION_ZKHOST_DEPRECATED, SolrCLI.OPTION_VERBOSE_DEPRECATED);
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        SolrCLI.raiseLogLevelUnlessVerbose(cli);
        try (SolrClient solrClient = SolrCLI.getSolrClient(cli);){
            Map systemInfo = solrClient.request((SolrRequest)new GenericSolrRequest(SolrRequest.METHOD.GET, "/admin/info/system")).asMap();
            if ("solrcloud".equals(systemInfo.get("mode"))) {
                this.deleteCollection(cli);
            } else {
                this.deleteCore(cli, solrClient);
            }
        }
    }

    protected void deleteCollection(CommandLine cli) throws Exception {
        Http2SolrClient.Builder builder = (Http2SolrClient.Builder)((Http2SolrClient.Builder)((Http2SolrClient.Builder)new Http2SolrClient.Builder().withIdleTimeout(30L, TimeUnit.SECONDS)).withConnectionTimeout(15L, TimeUnit.SECONDS)).withKeyStoreReloadInterval(-1L, TimeUnit.SECONDS).withOptionalBasicAuthCredentials(cli.getOptionValue("credentials"));
        String zkHost = SolrCLI.getZkHost(cli);
        try (CloudHttp2SolrClient cloudSolrClient = SolrCLI.getCloudHttp2SolrClient(zkHost, builder);){
            this.echoIfVerbose("Connecting to ZooKeeper at " + zkHost, cli);
            cloudSolrClient.connect();
            this.deleteCollection((CloudSolrClient)cloudSolrClient, cli);
        }
    }

    protected void deleteCollection(CloudSolrClient cloudSolrClient, CommandLine cli) throws Exception {
        NamedList response;
        Set liveNodes = cloudSolrClient.getClusterState().getLiveNodes();
        if (liveNodes.isEmpty()) {
            throw new IllegalStateException("No live nodes found! Cannot delete a collection until there is at least 1 live node in the cluster.");
        }
        ZkStateReader zkStateReader = ZkStateReader.from((CloudSolrClient)cloudSolrClient);
        String collectionName = cli.getOptionValue("name");
        if (!zkStateReader.getClusterState().hasCollection(collectionName)) {
            throw new IllegalArgumentException("Collection " + collectionName + " not found!");
        }
        String configName = zkStateReader.getClusterState().getCollection(collectionName).getConfigName();
        boolean deleteConfig = true;
        if (cli.hasOption("delete-config")) {
            deleteConfig = "true".equals(cli.getOptionValue("delete-config"));
        } else if (cli.hasOption("d")) {
            deleteConfig = "true".equals(cli.getOptionValue("d"));
        } else if (cli.hasOption("deleteConfig")) {
            deleteConfig = "true".equals(cli.getOptionValue("deleteConfig"));
        }
        if (deleteConfig && configName != null) {
            if (cli.hasOption("force") || cli.hasOption("force-delete-config") || cli.hasOption("forceDeleteConfig")) {
                log.warn("Skipping safety checks, configuration directory {} will be deleted with impunity.", (Object)configName);
            } else {
                Optional<String> inUse;
                Collection collections = zkStateReader.getClusterState().getCollectionNames();
                if (collections.size() > 50 && log.isInfoEnabled()) {
                    log.info("Scanning {} to ensure no other collections are using config {}", (Object)collections.size(), (Object)configName);
                }
                if ((inUse = collections.stream().filter(name -> !name.equals(collectionName)).filter(name -> configName.equals(zkStateReader.getClusterState().getCollection(name).getConfigName())).findFirst()).isPresent()) {
                    deleteConfig = false;
                    log.warn("Configuration directory {} is also being used by {}{}", new Object[]{configName, inUse.get(), "; configuration will not be deleted from ZooKeeper. You can pass the --force-delete-config flag to force delete."});
                }
            }
        }
        this.echoIfVerbose("\nDeleting collection '" + collectionName + "' using CollectionAdminRequest", cli);
        try {
            CollectionAdminRequest.Delete req = CollectionAdminRequest.deleteCollection((String)collectionName);
            req.setResponseParser((ResponseParser)new JsonMapResponseParser());
            response = cloudSolrClient.request((SolrRequest)req);
        }
        catch (SolrServerException sse) {
            throw new Exception("Failed to delete collection '" + collectionName + "' due to: " + sse.getMessage());
        }
        if (deleteConfig) {
            String configZnode = "/configs/" + configName;
            try {
                zkStateReader.getZkClient().clean(configZnode);
            }
            catch (Exception exc) {
                this.echo("\nWARNING: Failed to delete configuration directory " + configZnode + " in ZooKeeper due to: " + exc.getMessage() + "\nYou'll need to manually delete this znode using the zkcli script.");
            }
        }
        if (response != null) {
            CharArr arr = new CharArr();
            new JSONWriter(arr, 2).write(response.asMap(10));
            this.echo(arr.toString());
            this.echo("\n");
        }
        this.echo("Deleted collection '" + collectionName + "' using CollectionAdminRequest");
    }

    protected void deleteCore(CommandLine cli, SolrClient solrClient) throws Exception {
        NamedList response;
        String coreName = cli.getOptionValue("name");
        this.echo("\nDeleting core '" + coreName + "' using CoreAdminRequest\n");
        try {
            CoreAdminRequest.Unload unloadRequest = new CoreAdminRequest.Unload(true);
            unloadRequest.setDeleteIndex(true);
            unloadRequest.setDeleteDataDir(true);
            unloadRequest.setDeleteInstanceDir(true);
            unloadRequest.setCoreName(coreName);
            unloadRequest.setResponseParser((ResponseParser)new NoOpResponseParser("json"));
            response = solrClient.request((SolrRequest)unloadRequest);
        }
        catch (SolrServerException sse) {
            throw new Exception("Failed to delete core '" + coreName + "' due to: " + sse.getMessage());
        }
        if (response != null) {
            this.echoIfVerbose((String)response.get("response"), cli);
            this.echoIfVerbose("\n", cli);
        }
    }
}

