// This file is part of tdir, the Taler Directory implementation.
// Copyright (C) 2025 Martin Schanzenbach
//
// Taldir is free software: you can redistribute it and/or modify it
// under the terms of the GNU Affero General Public License as published
// by the Free Software Foundation, either version 3 of the License,
// or (at your option) any later version.
//
// Taldir is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// SPDX-License-Identifier: AGPL3.0-or-later

package taldir

import (
	"gorm.io/gorm"
	"time"
)

// Entry is a mapping from the alias hash to a target URI
type Entry struct {

	// ORM
	gorm.Model `json:"-"`

	// The salted hash (SHA512) of the hashed alias
	HsAlias string `json:"-"`

	// Target URI to associate with this alias
	TargetURI string `json:"target_uri"`

	// How long the registration lasts in microseconds
	Duration time.Duration `json:"-"`
}
