#! /bin/bash

# SPDX-FileCopyrightText: 2025 Feng Shu
#
# SPDX-License-Identifier: GPL-3.0-or-later


CURDIR=$(dirname "$(realpath "${BASH_SOURCE[0]}")")

cd ${CURDIR}

PY_FILES=$(find . -type f -name "*.py")
LOCALE_DIR=${CURDIR}/gnuhealth/data/locale

xgettext --from-code=UTF-8                                  \
         --force-po                                         \
         --omit-header                                      \
         --language=Python                                  \
         --output-dir=${LOCALE_DIR}                         \
         --no-location                                      \
         --output=tryton-extra.pot $PY_FILES

msgcat ${LOCALE_DIR}/tryton.pot ${LOCALE_DIR}/tryton-extra.pot  -o ${LOCALE_DIR}/tryton.pot
rm ${LOCALE_DIR}/tryton-extra.pot

for lang in bg cs es et fi hu it lo nl pt ru tr uk ca de \
               es_419 fa fr id ja_JP lt pl ro sl zh_CN
do
    lang_dir=${LOCALE_DIR}/${lang}/LC_MESSAGES/
    mkdir -p ${lang_dir}
    cd ${lang_dir}

    if [ -f tryton.po ]; then
        msgmerge --quiet --update --backup=none     \
                 --no-fuzzy-matching                \
                 tryton.po ../../tryton.pot

        msgattrib --no-obsolete tryton.po           \
                  --output-file tryton.po
    else
        msginit --input=../../tryton.pot            \
                --output-file=tryton.po             \
                --no-translator                     \
                --locale=tryton.UTF-8
    fi

    msgfmt tryton.po -o tryton.mo

done
