/*
 This file is part of GNU Taler
 (C) 2022-2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

import { Fragment, VNode, h } from "preact";
import { HTMLAttributes, useState } from "preact/compat";
import {
  SafeHandlerTemplate,
  useTranslationContext,
} from "../index.browser.js";

export interface ButtonHandler {
  onClick: (() => Promise<void>) | undefined;
}

interface Props extends HTMLAttributes<HTMLButtonElement> {
  handler: ButtonHandler | undefined;
}

/**
 * This button accept an async function and report a notification
 * on error or success.
 *
 * When the async function is running the inner text will change into
 * a "loading" animation.
 *
 * @deprecated use ButtonBetter
 *
 * @param param0
 * @returns
 */
export function Button({
  handler,
  children,
  disabled,
  onClick: clickEvent,
  ...rest
}: Props): VNode {
  const { i18n } = useTranslationContext();
  const [running, setRunning] = useState(false);
  return (
    <button
      {...rest}
      disabled={disabled || running}
      onClick={(e) => {
        e.preventDefault();
        if (!handler || !handler.onClick) {
          return;
        }
        setRunning(true);
        handler.onClick().finally(() => {
          setRunning(false);
        });
      }}
    >
      {running ? <Wait /> : children}
    </button>
  );
}

type PropsBetter = Omit<
  Omit<HTMLAttributes<HTMLButtonElement>, "onClick">,
  "disabled"
> & {
  onClick: SafeHandlerTemplate<any, any> | undefined;
};
/**
 * FIXME: removed deprecated and change for this one
 * @param param0
 * @returns
 */
export function ButtonBetter({
  children,
  onClick,
  ...rest
}: PropsBetter): VNode {
  const [running, setRunning] = useState(false);
  return (
    <button
        type="button"
      {...rest}
      disabled={running || !onClick || !onClick.args}
      onClick={(e) => {
        e.preventDefault();
        if (!onClick || !onClick.args) {
          return;
        }
        setRunning(true);
        onClick.call().finally(() => {
          setRunning(false);
        });
      }}
    >
      {running ? <Wait /> : children}
    </button>
  );
}

// FIXME: we should stop using bulma css and remove all of this support
export function ButtonBetterBulma({
  children,
  onClick,
  ...rest
}: PropsBetter & {"data-tooltip"?: string,}): VNode {
  const [running, setRunning] = useState(false);
  return (
      <button
        class="button is-success"
        type="button"
        {...rest as any}
        disabled={running || !onClick || !onClick.args}
        onClick={(e) => {
          e.preventDefault();
          if (!onClick || !onClick.args) {
            return;
          }
          setRunning(true);
          onClick.call().finally(() => {
            setRunning(false);
          });
        }}
      >
        {running ? <Wait /> : children}
      </button>
  );
}

function Wait(): VNode {
  return (
    <Fragment>
      <div id="l1" />
    </Fragment>
  );
}
