/**
 * SPDX-FileCopyrightText: 2021 Aleix Pol i Gonzalez <aleixpol@kde.org>
 *
 * SPDX-License-Identifier: GPL-2.0-only OR GPL-3.0-only OR LicenseRef-KDE-Accepted-GPL
 */

#pragma once

#include "plugin_virtualmonitor_debug.h"
#include <QJsonObject>
#include <core/kdeconnectplugin.h>

#define PACKET_TYPE_VIRTUALMONITOR QStringLiteral("kdeconnect.virtualmonitor")
#define PACKET_TYPE_VIRTUALMONITOR_REQUEST QStringLiteral("kdeconnect.virtualmonitor.request")

class QProcess;

class VirtualMonitorPlugin : public KdeConnectPlugin
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.kde.kdeconnect.device.virtualmonitor")

public:
    using KdeConnectPlugin::KdeConnectPlugin;
    ~VirtualMonitorPlugin() override;

    Q_SCRIPTABLE bool requestVirtualMonitor();

    void connected() override;
    QString dbusPath() const override;
    void receivePacket(const NetworkPacket &np) override;

private:
    void stop();

    QProcess *m_process = nullptr;
    QJsonObject m_remoteResolution;
    uint m_retries = 0;
};
