/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

#include <qmessagebox.h> 
#include <qpainter.h>
#include <qfiledialog.h> 
#include <qfont.h>
#include <qwt_thermo.h>
#include <qwt_plot.h>
#include <qwt_dimap.h>
#include <qwt_curve.h>
#include <qlabel.h>
#include <qwt_math.h>
#include "nn.h"
#include "simpleplot.h"
#include <.ui/helpwindow.h>
#include <qtextbrowser.h>

#define MAXLENGTH 100000   // max length of a plot

nn *nn1;     // global neural network;
Plot *plot;  // global plot
helpWindow *helpwin; // global help window
 
// read in data
void nnqt::init()
{
    nn1=new nn();
    qwtThermo1->setRange(0,100);
    qwtPlot1->setTitle("Model versus data plot");
    qwtPlot1->setAutoLegend(TRUE); // We want a legend
    qwtPlot1->setLegendPos(Qwt::Right);

    // Set axis titles
    qwtPlot1->setAxisTitle(QwtPlot::xBottom, "model -->");
    qwtPlot1->setAxisTitle(QwtPlot::yLeft, "data -->");
    qwtPlot1->enableGridX(TRUE);
    qwtPlot1->enableGridY(TRUE);
    
    // plot for 2d view
    qwtPlot2d->setTitle("2D-View");
    qwtPlot2d->setAutoLegend(TRUE); // We want a legend
    qwtPlot2d->setLegendPos(Qwt::Right);

    // Set axis titles
    qwtPlot2d->setAxisTitle(QwtPlot::xBottom, "x -->");
    qwtPlot2d->setAxisTitle(QwtPlot::yLeft, "y -->");
    qwtPlot2d->enableGridX(TRUE);
    qwtPlot2d->enableGridY(TRUE);

    
    x=y1=0;
    is_trained=is_read=has_data=has_test=is_coded=false;
    plot=0;
    helpwin= new helpWindow();
    QString p;
    QStringList path;
    p=getenv("NN_HOME");
    p+="/doc";
    path+=p;
    p+="/Pictures";
    path+=p;
    helpwin->browser->mimeSourceFactory()->setFilePath(path);
    helpwin->browser->setSource("nnqt.html");
  }

void nnqt::fileOpen()
{
    // ask the Data-IO options
    if(space_sep->isChecked()==true) nn1->set_separator(' ');
    if(tab_sep->isChecked()==true) nn1->set_separator('\t');
    if(semi_sep->isChecked()==true) nn1->set_separator(';');
    if(comma_sep->isChecked()==true) nn1->set_separator(',');
    nn1->set_n_header(spinBox1->value());
    // read in
    QString nn_home=QString(getenv("NN_HOME"))+QString("/data");
    QString output=lineEdit1->text();
    if(output=="last")nn1->set_y_output(-1);
    else
	nn1->set_y_output(output.toInt());
    QString s = QFileDialog::getOpenFileName(
	nn_home,
	"Images (*.csv *.txt)",
	this,
	"open file dialog"
	"Choose a file" );
    if(s.isEmpty()) return;
    if(nn1->read_data(s)==true){
	unsigned int n_elements=nn1->get_n_elements();
	for(unsigned int i=0; i<n_elements; i++){
	    QString num;
	    num.setNum(nn1->get_min(i));
	    table1->setText(i,0,num);
	    num.setNum(nn1->get_max(i));
	    table1->setText(i,1,num);
	    num.setNum(nn1->get_mean(i));
	    table1->setText(i,2,num);
	    num.setNum(nn1->get_var(i));
	    table1->setText(i,3,num);
	    num.setNum(nn1->get_corr(i));
	    table1->setText(i,4,num);
	}
	// make thermo true
	qwtThermo1->setRange(0,0.1);
	max_error->setText(s.setNum(0.316/nn1->get_n_lines()));
    }    
    has_data=true;
    tabWidget2->setCurrentPage ( 1 );
}

void nnqt::fileSave()
{
    if(is_trained==false)return;
    QString nn_home=QString(getenv("NN_HOME"))+QString("/models");
    QString s = QFileDialog::getSaveFileName(
	nn_home,
	"Images (*.net *.mod)",
	this,
	"save file dialog"
	"Choose a filename to save under" );
    if(s.isEmpty()) return;
    FILE *fp;
    fp=fopen(s.ascii(),"w");
    nn1->save_network(fp);
    fclose(fp);
}

void nnqt::helpContents()
{
    if (! helpwin->isShown()) {
        helpwin->show();

    }
    else
        helpwin->raise();

}

void nnqt::helpAbout()
{
     QMessageBox::information( this, "nnqt as part of SAMT",
			       "Toolbox neural networks\n"
			       "Version 0.1 30.6.2004\n"
			       "Developer: Dr. Ralf Wieland\n");
}

void nnqt::start()
{
    if(is_trained==false) return;
    unsigned int train_number;
    QString s=n_trails->text();
    if(!s.isEmpty())
	train_number=s.toInt();
    else
	train_number=1000;
    unsigned int iter=(int)train_number;
    double err;
    qwtThermo1->setFillColor(blue);
    QApplication::setOverrideCursor(waitCursor);
    if(bp_button->isChecked()){
	err=nn1->step_bp(iter);
	line_error->setText(s.setNum(err));
	qwtThermo1->setValue(err);
    }
    if(bpm_button->isChecked()){
	err=nn1->step_bp(iter);
	line_error->setText(s.setNum(err)); 
	qwtThermo1->setValue(err);
    }
    if(lm_button->isChecked()){
	err=nn1->step_lm(iter/10);
	line_error->setText(s.setNum(err)); 
	qwtThermo1->setValue(err);
    }
    QApplication::restoreOverrideCursor();
}


void nnqt::load_model()
{
    QString s;
    int count=0;
    if(has_data==false) return;
    for(unsigned int i=0;i<nn1->get_n_elements();i++){
	s=table1->text(i,5);
	if(!s.isEmpty()){
	    is_coded=true;
	    nn1->set_coder(count++,i);
	}
    }
    if(is_coded==false) return;
    nn1->set_n_inputs(count);
    is_coded=false;
    QString nn_home=QString(getenv("NN_HOME"))+QString("/models");
     s= QFileDialog::getOpenFileName(
	nn_home,
	"Images (*.net *.mod)",
	this,
	"open file dialog"
	"Choose a file" );
    if(s.isEmpty()) return;
    FILE *fp;
    fp=fopen(s.ascii(),"r");
    if(fp==0){
	fprintf(stderr,"(error load_model): can not open:%s\n",s.ascii());
	return;
    }
    nn1->load_network(fp);
    fclose(fp);
    is_read=true;
    QString num,used;
    unsigned k=0;
    for(unsigned int i=0; i<nn1->get_n_elements(); i++)
	for(unsigned int j=0; j<4; j++)
	    table2->setText(i,j,"");
    for(unsigned int i=0; i<nn1->get_n_elements(); i++){
	used=table1->text(i,5);
	if(!used.isEmpty() && used.toDouble()==1){
	    num.setNum(nn1->get_min(nn1->get_coder(k)));
	    table2->setText(k,0,num);
	    num.setNum(nn1->get_max(nn1->get_coder(k)));
	    table2->setText(k,1,num);
	    num.setNum(nn1->get_mean(nn1->get_coder(k)));
	    table2->setText(k,2,num);
	    num="";
	    table2->setText(k,3,num);
	    k++;
	}
    }
}

void nnqt::save_test()
{}

void nnqt::start_test()
{
    if(is_trained==false && is_read==false) return;
    long curve1,curve2;
    QString num;
    QString used;
    qwtPlot1->clear();
    int length1,length2;
    QwtSymbol sym;
    double xsoll[2],ysoll[2];
    length1=nn1->get_n_lines();
    length2=nn1->get_t_lines();
    if(length1<2 && length1>MAXLENGTH) return;
    // allocate memory
    if(x==0) x=new double[length1+length2];
    if(y1==0) y1=new double[length1+length2];
    if(x==0 || y1==0){
	fprintf(stderr,"(error start_length:) no space on divice: %d\n",
		length1+length2);
	return;
    }
    // scale
    double s_min,s_max;
    s_min=(nn1->get_min(nn1->get_y_output()));
    s_max=(nn1->get_max(nn1->get_y_output()));
    FILE *fp;
    QString nn_home=QString(getenv("NN_HOME"))+QString("/data/result.txt");
    fp=fopen(nn_home.ascii(),"w");
    for(unsigned int i=0; i<(unsigned int)length1; i++){
	x[i]=0.5*(s_max+s_min+(s_max-s_min)*nn1->get_network(i));
	y1[i]=0.5*(s_max+s_min+(s_max-s_min)*nn1->get_output(i));
	fprintf(fp,"%lf\n",x[i]);
    }
    fclose(fp);
    sym.setStyle(QwtSymbol::Cross);
    sym.setPen(blue);
    sym.setSize(5);

    curve1 = qwtPlot1->insertCurve("net");
    qwtPlot1->setCurveStyle(curve1, QwtCurve::NoCurve); 
    qwtPlot1->setCurveSymbol(curve1,sym);
    qwtPlot1->setCurveData(curve1, x, y1, length1);
    curve2 = qwtPlot1->insertCurve("soll");
    xsoll[0]=ysoll[0]=s_min;
    xsoll[1]=ysoll[1]=s_max;
    qwtPlot1->setCurvePen(curve2, QPen(red));
    qwtPlot1->setCurveData(curve2, xsoll, ysoll, 2);
    qwtPlot1->replot();
    tabWidget2->setCurrentPage ( 3 );
}


void nnqt::gen_network()
{
    QString s;
    int count=0;
    if(has_data==false) return;
    if(nn1==0) return;
    if(checkBox1_shuffle->isChecked()==TRUE)
	nn1->set_shuffle(true);
    else
	nn1->set_shuffle(false);
    for(unsigned int i=0;i<nn1->get_n_elements();i++){
	s=table1->text(i,5);
	if(!s.isEmpty()){
	    is_coded=true;
	    nn1->set_coder(count,i);
	    count++;
	}
    }
    if(is_coded==false) return;
    is_coded=false;
    nn1->set_n_inputs(count);
    s=max_error->text();
    if(!s.isEmpty())
	nn1->set_max_error(s.toDouble());
    else
	nn1->set_max_error(0.01);
    s=n_hidden->text();
    if(!s.isEmpty())
	nn1->set_n_hidden(s.toInt());
    else
	return;
    if(bp_button->isChecked()){
	if(is_trained==true) nn1->mem_free();
	nn1->train_bp();
    }
    if(bpm_button->isChecked()){
	if(is_trained==true) nn1->mem_free();
	nn1->train_bpm();
    }
    if(lm_button->isChecked()){
	if(is_trained==true) nn1->mem_free();
	nn1->train_lm();
    }
    is_trained=true;
    unsigned int k=0;
    QString num,used;
    for(unsigned int i=0; i<nn1->get_n_elements(); i++)
	for(unsigned int j=0; j<4; j++)
	    table2->setText(i,j,"");
    for(unsigned int i=0; i<nn1->get_n_elements(); i++){
	used=table1->text(i,5);
	if(!used.isEmpty() && used.toDouble()==1){
	    num.setNum(nn1->get_min(nn1->get_coder(k)));
	    table2->setText(k,0,num);
	    num.setNum(nn1->get_max(nn1->get_coder(k)));
	    table2->setText(k,1,num);
	    num.setNum(nn1->get_mean(nn1->get_coder(k)));
	    table2->setText(k,2,num);
	    num="";
	    table2->setText(k,3,num);
	    k++;
	}
    }
}

void nnqt::reset_w()
{
    if(has_data==false || is_trained==false) return;
    nn1->reset();
}

void nnqt::start_control()
{
    double err;
    QString s;
    if((is_trained==false && is_read==false) || has_test==false) return;
    long curve1,curve2;
    int length1,length2;
    QwtSymbol sym;
    double xsoll[2],ysoll[2];
    if((err=nn1->t_calc())<0) return;
    line_error->setText(s.setNum(err)); 
    qwtThermo1->setFillColor(red);
    qwtThermo1->setValue(err);
    qwtPlot1->clear();
    length2=nn1->get_t_lines();
    length1=nn1->get_n_lines();
    if(length1<2 && length1>MAXLENGTH) return;
    // allocate memory
    if(x==0) x=new double[length1+length2];
    if(y1==0) y1=new double[length1+length2];
    if(x==0 || y1==0){
	fprintf(stderr,"(error start_length:) no space on divice: %d\n",
		length1+length2);
	return;
    }
    // scale
    double s_min,s_max;
    s_min=(nn1->get_min(nn1->get_y_output()));
    s_max=(nn1->get_max(nn1->get_y_output()));
    FILE *fp;
    QString nn_home=QString(getenv("NN_HOME"))+QString("/data/tresult.txt");
    fp=fopen(nn_home.ascii(),"w");
    for(unsigned int i=0; i<(unsigned int)length2; i++){
	x[i]=0.5*(s_max+s_min+(s_max-s_min)*nn1->get_t_network(i));
	y1[i]=0.5*(s_max+s_min+(s_max-s_min)*nn1->get_t_output(i));
	fprintf(fp,"%lf\n",x[i]);
    }
    fclose(fp);
    sym.setStyle(QwtSymbol::Cross);
    sym.setPen(red);
    sym.setSize(5);

    curve1 = qwtPlot1->insertCurve("test");
    qwtPlot1->setCurveStyle(curve1, QwtCurve::NoCurve); 
    qwtPlot1->setCurveSymbol(curve1,sym);
    qwtPlot1->setCurveData(curve1, x, y1, length2);
    curve2 = qwtPlot1->insertCurve("soll");
    xsoll[0]=ysoll[0]=s_min;
    xsoll[1]=ysoll[1]=s_max;
    qwtPlot1->setCurvePen(curve2, QPen(black));
    qwtPlot1->setCurveData(curve2, xsoll, ysoll, 2);
    qwtPlot1->replot();
    // tabWidget2->setCurrentPage ( 3 );
}



void nnqt::gen_test()
{
    // ask the Data-IO options
    if(space_sep->isChecked()==true) nn1->set_separator(' ');
    if(tab_sep->isChecked()==true) nn1->set_separator('\t');
    if(semi_sep->isChecked()==true) nn1->set_separator(';');
    if(comma_sep->isChecked()==true) nn1->set_separator(',');
    nn1->set_n_header(spinBox1->value());
    // read in
    QString nn_home=QString(getenv("NN_HOME"))+QString("/data");
    QString output=lineEdit1->text();
    if(output=="last")nn1->set_y_output(-1);
    else
	nn1->set_y_output(output.toInt());
    QString s = QFileDialog::getOpenFileName(
	nn_home,
	"Images (*.csv *.txt)",
	this,
	"open file dialog"
	"Choose a file" );
    if(s.isEmpty()) return;
    if(nn1->gen_test_data(s)==true){
	int n_elements=nn1->get_n_elements();
	for(int i=0; i<n_elements; i++){
	    QString num;
	    num.setNum(nn1->get_min(i));
	    table1->setText(i,0,num);
	    num.setNum(nn1->get_max(i));
	    table1->setText(i,1,num);
	    num.setNum(nn1->get_mean(i));
	    table1->setText(i,2,num);
	    num.setNum(nn1->get_var(i));
	    table1->setText(i,3,num);
	    num.setNum(nn1->get_corr(i));
	    table1->setText(i,4,num);
	}
	// make thermo true
	qwtThermo1->setRange(0,0.1);
	max_error->setText(s.setNum(0.316/nn1->get_n_lines()));
    }    
    has_data=true;
    has_test=true;
    tabWidget2->setCurrentPage ( 1 );
}


void nnqt::view_3d()
{
    double xmin,xmax,ymin,ymax,value=0.0;
    unsigned int count=0;
    xmin=xmax=ymin=ymax=0.0;
    if((is_trained==false && is_read==false)) return;
    if(checkBox3D->isChecked()==TRUE)
	nn1->set_norm(true);
    else
	nn1->set_norm(false);
    for(unsigned int i=0; i<nn1->get_n_inputs(); i++){
	QString use,def,val;
	def=table2->text(i,2);
	use=table2->text(i,3);
	if(!use.isEmpty()){
	    nn1->set_input(i,1);
	    if(count++==0){ // x values
		val=table2->text(i,0);  // min
		xmin=val.toDouble();
		val=table2->text(i,1);  // max
		xmax=val.toDouble();
	    }
	    else{    // y values
		val=table2->text(i,0);  // min
		ymin=val.toDouble();
		val=table2->text(i,1);  // max
		ymax=val.toDouble();
	    }
	}
	else nn1->set_input(i,0);
	if(!def.isEmpty()){
	    value=def.toDouble();
	    value=2.0*(value-(nn1->get_min(nn1->get_coder(i))))/
		((nn1->get_max(nn1->get_coder(i)))-
		 (nn1->get_min(nn1->get_coder(i))))-1.0;
	    nn1->set_default(i,value);
	}
    }
    if(plot!=0) delete plot; 
    if(checkBox3D->isChecked()==TRUE)
	plot=new Plot(frame3,xmin,xmax,ymin,ymax,true);
    else
	plot=new Plot(frame3,-1,1,-1,1,false);
    plot->resize(frame3->width(),frame3->height());
    plot->show();
    tabWidget2->setCurrentPage ( 6 );
}




void nnqt::view_2d()
{
    int length=200;
    unsigned int count=0;
    double xmin,xmax,deltax,value=0.0;
    long curve1;

    xmin=xmax=deltax=0;
    qwtPlot2d->clear();
    if((is_trained==false && is_read==false)) return;
    if(checkBox3D->isChecked()==TRUE)
	nn1->set_norm(true);
    else
	nn1->set_norm(false);
    for(unsigned int i=0; i<nn1->get_n_inputs(); i++){
	QString use,def,val1,val2;
	def=table2->text(i,2);
	use=table2->text(i,3);
	if(!use.isEmpty() && count==0){
	    nn1->set_input(i,1);
	    val1=table2->text(i,0);  // min
	    xmin=val1.toDouble();
	    val2=table2->text(i,1);  // max
	    xmax=val2.toDouble();
	    count++;
	    deltax=(xmax-xmin)/(length+1);
	}
	else nn1->set_input(i,0);
	if(!def.isEmpty()){
	    value=def.toDouble();
	    value=2.0*(value-(nn1->get_min(nn1->get_coder(i))))/
		((nn1->get_max(nn1->get_coder(i)))-
		 (nn1->get_min(nn1->get_coder(i))))-1.0;
	    nn1->set_default(i,value);
	}
    }
    fprintf(stderr,"2d: min=%f max=%f delta=%f\n",xmin,xmax,deltax);
    x_view[0]=-deltax;
    for(int i=0;i<length; i++){
	x_view[i]=deltax*i+xmin;
	y_view[i]=nn1->get_2d(x_view[i]);
    }
    curve1 = qwtPlot2d->insertCurve("net");
    qwtPlot2d->setCurvePen(curve1, QPen(blue));
    qwtPlot2d->setCurveData(curve1, x_view, y_view, 200);
    qwtPlot2d->replot();
    tabWidget2->setCurrentPage ( 5 );
}
