import { select } from '@inquirer/prompts';
import Keyboards from '../../classes/keyboards.js';
/**
 *
 */
export default async function selectKeyboardModel(selected = '') {
    const keyboards = new Keyboards();
    const models = keyboards.getModels();
    const supported = [];
    for (const m of models) {
        supported.push(m.code);
    }
    const choices = supported.map((m) => ({ name: m, value: m }));
    const answer = await select({
        message: 'Select model: ',
        choices,
        default: selected,
    });
    return answer;
}
