/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.DeclarationFormattingContext;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.ShorthandBuilder;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.TypedValue;
import io.sf.carte.doc.style.css.property.ValueList;
import io.sf.carte.util.BufferSimpleWriter;
import java.util.Locale;
import java.util.Set;

class MaskBuilder
extends ShorthandBuilder {
    private StyleValue mskimage;
    private StyleValue mskposition;
    private StyleValue msksize;
    private StyleValue mskrepeat;
    private StyleValue mskorigin;
    private StyleValue mskclip;
    private StyleValue mskcomposite;
    private StyleValue mskmode;
    private boolean appended = false;

    MaskBuilder(BaseCSSStyleDeclaration parentStyle) {
        super("mask", parentStyle);
    }

    @Override
    protected int getMinimumSetSize() {
        return 14;
    }

    @Override
    int appendShorthandSet(StringBuilder buf, Set<String> declaredSet, boolean important) {
        buf.append(this.getShorthandName()).append(':');
        this.mskimage = this.getCSSValue("mask-image");
        this.mskposition = this.computeMultipleSubproperty("mask-image", "mask-position");
        this.msksize = this.computeMultipleSubproperty("mask-image", "mask-size");
        this.mskrepeat = this.computeMultipleSubproperty("mask-image", "mask-repeat");
        this.mskorigin = this.computeMultipleSubproperty("mask-image", "mask-origin");
        this.mskclip = this.computeMultipleSubproperty("mask-image", "mask-clip");
        this.mskcomposite = this.computeMultipleSubproperty("mask-image", "mask-composite");
        this.mskmode = this.computeMultipleSubproperty("mask-image", "mask-mode");
        CSSValue.CssType type = this.mskimage.getCssValueType();
        if (type == CSSValue.CssType.LIST && ((ValueList)this.mskimage).isCommaSeparated()) {
            if (!this.appendLayered(buf, declaredSet, ((ValueList)this.mskimage).getLength())) {
                return 1;
            }
        } else {
            byte inheritcheck = this.checkForCssKeyword(CSSValue.Type.INHERIT);
            if (inheritcheck == 1) {
                buf.append("inherit");
                this.appendPriority(buf, important);
                BufferSimpleWriter wri = new BufferSimpleWriter(buf);
                DeclarationFormattingContext context = this.getParentStyle().getFormattingContext();
                this.serializeMaskBorderIfNot(CSSValue.Type.INHERIT, wri, context, important);
                return 0;
            }
            if (inheritcheck == 2) {
                return 1;
            }
            byte check = this.checkForCssKeyword(CSSValue.Type.REVERT);
            if (check == 1) {
                buf.append("revert");
                this.appendPriority(buf, important);
                BufferSimpleWriter wri = new BufferSimpleWriter(buf);
                DeclarationFormattingContext context = this.getParentStyle().getFormattingContext();
                this.serializeMaskBorderIfNot(CSSValue.Type.REVERT, wri, context, important);
                return 0;
            }
            if (check == 2) {
                return 1;
            }
            if (!this.appendImage(buf, this.mskimage)) {
                return 1;
            }
            if (!this.appendSingleLayer(buf, declaredSet)) {
                return 1;
            }
            if (!this.appended) {
                buf.append("none");
            }
        }
        this.appendPriority(buf, important);
        BufferSimpleWriter wri = new BufferSimpleWriter(buf);
        DeclarationFormattingContext context = this.getParentStyle().getFormattingContext();
        this.serializeMaskBorderIfNotInitial(wri, context, important);
        return 0;
    }

    private StyleValue computeMultipleSubproperty(String masterProperty, String propertyName) {
        return this.getParentStyle().computeBoundProperty(masterProperty, propertyName, this.getCSSValue(propertyName));
    }

    private byte checkForCssKeyword(CSSValue.Type keyword) {
        int ucount = 0;
        if (MaskBuilder.isCssValueOfType(keyword, this.mskimage)) {
            ucount = (byte)(ucount + 1);
        }
        if (MaskBuilder.isCssValueOfType(keyword, this.mskposition)) {
            ucount = (byte)(ucount + 1);
        }
        if (MaskBuilder.isCssValueOfType(keyword, this.msksize)) {
            ucount = (byte)(ucount + 1);
        }
        if (MaskBuilder.isCssValueOfType(keyword, this.mskrepeat)) {
            ucount = (byte)(ucount + 1);
        }
        if (MaskBuilder.isCssValueOfType(keyword, this.mskorigin)) {
            ucount = (byte)(ucount + 1);
        }
        if (MaskBuilder.isCssValueOfType(keyword, this.mskclip)) {
            ucount = (byte)(ucount + 1);
        }
        if (MaskBuilder.isCssValueOfType(keyword, this.mskcomposite)) {
            ucount = (byte)(ucount + 1);
        }
        if (MaskBuilder.isCssValueOfType(keyword, this.mskmode)) {
            ucount = (byte)(ucount + 1);
        }
        switch (ucount) {
            case 0: {
                return 0;
            }
            case 8: {
                return 1;
            }
        }
        return 2;
    }

    private void appendText(StringBuilder buf, String text) {
        if (this.appended) {
            buf.append(' ');
        } else {
            this.appended = true;
        }
        buf.append(text);
    }

    private boolean appendLayered(StringBuilder buf, Set<String> declaredSet, int listlen) {
        int szm1 = listlen - 1;
        if (!this.appendLayer(buf, declaredSet, 0, szm1)) {
            return false;
        }
        for (int i = 1; i <= szm1; ++i) {
            this.appended = false;
            buf.append(',');
            if (this.appendLayer(buf, declaredSet, i, szm1)) continue;
            return false;
        }
        return true;
    }

    private boolean appendLayer(StringBuilder buf, Set<String> declaredSet, int index, int lastIndex) {
        StyleValue clip;
        StyleValue origin;
        StyleValue sizeval;
        if (declaredSet.contains("mask-image") && !this.appendImage(buf, ((ValueList)this.mskimage).item(index))) {
            return false;
        }
        ValueList list = (ValueList)this.mskposition;
        StyleValue posval = declaredSet.contains("mask-position") ? list.item(index) : null;
        if (!this.appendPositionSize(buf, posval, sizeval = declaredSet.contains("mask-size") ? ((ValueList)this.msksize).item(index) : null)) {
            return false;
        }
        if (declaredSet.contains("mask-repeat") && !this.appendRepeat(buf, ((ValueList)this.mskrepeat).item(index))) {
            return false;
        }
        boolean bcset = declaredSet.contains("mask-clip");
        if ((declaredSet.contains("mask-origin") || bcset) && !this.appendOriginClip(buf, origin = ((ValueList)this.mskorigin).item(index), clip = bcset ? ((ValueList)this.mskclip).item(index) : null)) {
            return false;
        }
        if (declaredSet.contains("mask-composite") && !this.appendNonInheritedPty(buf, (list = (ValueList)this.mskcomposite).item(index), "mask-composite")) {
            return false;
        }
        if (declaredSet.contains("mask-mode") && !this.appendNonInheritedPty(buf, (list = (ValueList)this.mskmode).item(index), "mask-mode")) {
            return false;
        }
        int buflen = buf.length();
        if (buflen == 5 || buf.charAt(buflen - 1) == ',') {
            buf.append("none");
        }
        return true;
    }

    private boolean appendSingleLayer(StringBuilder buf, Set<String> declaredSet) {
        StyleValue clip;
        StyleValue origin;
        StyleValue sizeval;
        StyleValue posval = declaredSet.contains("mask-position") ? this.valueOrFirstItem(this.mskposition) : null;
        if (!this.appendPositionSize(buf, posval, sizeval = declaredSet.contains("mask-size") ? this.valueOrFirstItem(this.msksize) : null)) {
            return false;
        }
        if (declaredSet.contains("mask-repeat") && !this.appendRepeat(buf, this.valueOrFirstItem(this.mskrepeat))) {
            return false;
        }
        boolean bcset = declaredSet.contains("mask-clip");
        if ((declaredSet.contains("mask-origin") || bcset) && !this.appendOriginClip(buf, origin = this.valueOrFirstItem(this.mskorigin), clip = bcset ? this.valueOrFirstItem(this.mskclip) : null)) {
            return false;
        }
        if (declaredSet.contains("mask-composite") && !this.appendNonInheritedPty(buf, this.valueOrFirstItem(this.mskcomposite), "mask-composite")) {
            return false;
        }
        return !declaredSet.contains("mask-mode") || this.appendNonInheritedPty(buf, this.valueOrFirstItem(this.mskmode), "mask-mode");
    }

    private StyleValue valueOrFirstItem(StyleValue value) {
        ValueList list;
        if (value.getCssValueType() == CSSValue.CssType.LIST && (list = (ValueList)value).isCommaSeparated()) {
            return list.item(0);
        }
        return value;
    }

    private boolean appendImage(StringBuilder buf, StyleValue value) {
        if (!this.isRevertValue(value) && this.shorthandMaskImage(value)) {
            this.appended = this.appendImage(buf, this.appended, value);
            return true;
        }
        return false;
    }

    private boolean shorthandMaskImage(StyleValue value) {
        CSSValue.CssType category = value.getCssValueType();
        if (category == CSSValue.CssType.TYPED) {
            TypedValue primi = (TypedValue)value;
            CSSValue.Type type = primi.getPrimitiveType();
            if (type == CSSValue.Type.IDENT) {
                String s = primi.getStringValue();
                return "none".equalsIgnoreCase(s);
            }
            return MaskBuilder.isImagePrimitiveValue(primi);
        }
        return category == CSSValue.CssType.KEYWORD;
    }

    private boolean appendPositionSize(StringBuilder buf, StyleValue posvalue, StyleValue sizevalue) {
        boolean appended = false;
        if (posvalue != null) {
            CSSValue.CssType type = posvalue.getCssValueType();
            String text = posvalue.getCssText().toLowerCase(Locale.ROOT);
            if (this.isRevertValue(posvalue)) {
                return false;
            }
            if (type == CSSValue.CssType.TYPED) {
                this.appendText(buf, text);
                appended = true;
            } else if (type == CSSValue.CssType.LIST) {
                ValueList list = (ValueList)posvalue;
                if (list.isCommaSeparated() || text.indexOf(92) != -1) {
                    return false;
                }
                if (!("0% 0%".equals(text) || "left top".equals(text) || "top left".equals(text))) {
                    if (list.getLength() != 2 || !"center".equals(list.item(1).getCssText())) {
                        this.appendText(buf, text);
                    } else {
                        this.appendText(buf, list.item(0).getCssText());
                    }
                    appended = true;
                }
            } else if (type == CSSValue.CssType.PROXY) {
                return false;
            }
        }
        if (sizevalue != null) {
            if (!this.isRevertValue(sizevalue) && !MaskBuilder.isUnknownIdentifier("mask-size", sizevalue) && sizevalue.getCssValueType() != CSSValue.CssType.PROXY) {
                String text = sizevalue.getMinifiedCssText("mask-size").toLowerCase(Locale.ROOT);
                if (!("auto".equals(text) || "auto auto".equals(text) || "initial".equals(text) || "unset".equals(text))) {
                    if (!appended) {
                        if (posvalue == null) {
                            posvalue = this.getCSSValue("mask-position");
                        }
                        this.appendText(buf, posvalue.getMinifiedCssText("mask-position"));
                    }
                    buf.append('/').append(text);
                    appended = true;
                }
            } else {
                return false;
            }
        }
        if (appended) {
            this.appended = true;
        }
        return true;
    }

    private boolean appendRepeat(StringBuilder buf, StyleValue value) {
        CSSValue.CssType type = value.getCssValueType();
        String text = value.getCssText().toLowerCase(Locale.ROOT);
        if (!MaskBuilder.isIdentOrKeyword(value) || MaskBuilder.isUnknownIdentifier("mask-repeat", value) || this.isRevertValue(value) || text.indexOf(92) != -1) {
            return false;
        }
        if (type == CSSValue.CssType.TYPED) {
            if (!"repeat".equals(text)) {
                this.appendText(buf, text);
            }
        } else if (type == CSSValue.CssType.LIST) {
            ValueList list = (ValueList)value;
            if (list.isCommaSeparated()) {
                return false;
            }
            if (!"repeat repeat".equals(text)) {
                if ("no-repeat no-repeat".equals(text)) {
                    this.appendText(buf, "no-repeat");
                } else if ("space space".equals(text)) {
                    this.appendText(buf, "space");
                } else if ("round round".equals(text)) {
                    this.appendText(buf, "round");
                } else if ("repeat no-repeat".equals(text)) {
                    this.appendText(buf, "repeat-x");
                } else if ("no-repeat repeat".equals(text)) {
                    this.appendText(buf, "repeat-y");
                } else {
                    this.appendText(buf, text);
                }
            }
        }
        return true;
    }

    private boolean appendNonInheritedPty(StringBuilder buf, StyleValue value, String propertyName) {
        if (!this.isRevertValue(value) && !MaskBuilder.isUnknownIdentifier(propertyName, value) && value.getCssValueType() != CSSValue.CssType.PROXY) {
            String text = value.getMinifiedCssText(propertyName).toLowerCase(Locale.ROOT);
            if (this.isNotInitialValue(value, propertyName) && !"initial".equals(text) && !"unset".equals(text)) {
                this.appendText(buf, text);
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean appendOriginClip(StringBuilder buf, StyleValue origin, StyleValue clip) {
        String originText;
        boolean originIsInitial;
        String clipText;
        boolean clipIsInitial;
        block14: {
            block15: {
                block13: {
                    block11: {
                        block12: {
                            block10: {
                                if (clip != null) break block10;
                                clipIsInitial = true;
                                clipText = "border-box";
                                break block11;
                            }
                            if (clip.getCssValueType() != CSSValue.CssType.KEYWORD) break block12;
                            switch (clip.getPrimitiveType()) {
                                case INITIAL: 
                                case UNSET: {
                                    clipIsInitial = true;
                                    clipText = "border-box";
                                    break block11;
                                }
                                default: {
                                    return false;
                                }
                            }
                        }
                        clipText = clip.getMinifiedCssText().toLowerCase(Locale.ROOT);
                        clipIsInitial = "border-box".equals(clipText);
                    }
                    if (origin != null) break block13;
                    originIsInitial = true;
                    originText = "border-box";
                    break block14;
                }
                if (origin.getCssValueType() != CSSValue.CssType.KEYWORD) break block15;
                switch (origin.getPrimitiveType()) {
                    case INITIAL: 
                    case UNSET: {
                        originIsInitial = true;
                        originText = "border-box";
                        break block14;
                    }
                    default: {
                        return false;
                    }
                }
            }
            originText = origin.getMinifiedCssText().toLowerCase(Locale.ROOT);
            originIsInitial = "border-box".equals(originText);
        }
        if (!originIsInitial || !clipIsInitial) {
            if (MaskBuilder.getShorthandDatabase().isIdentifierValue("mask-origin", originText) && MaskBuilder.getShorthandDatabase().isIdentifierValue("mask-clip", clipText)) {
                this.appendText(buf, originText);
                if (!originText.equals(clipText)) {
                    this.appendText(buf, clipText);
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private boolean isRevertValue(StyleValue cssValue) {
        return MaskBuilder.isCssValueOfType(CSSValue.Type.REVERT, cssValue);
    }

    private void serializeMaskBorderIfNot(CSSValue.Type keyword, BufferSimpleWriter wri, DeclarationFormattingContext context, boolean important) {
        this.appendDeclarationIfNotKeyword(keyword, wri, context, "mask-border-source", important);
        this.appendDeclarationIfNotKeyword(keyword, wri, context, "mask-border-slice", important);
        this.appendDeclarationIfNotKeyword(keyword, wri, context, "mask-border-width", important);
        this.appendDeclarationIfNotKeyword(keyword, wri, context, "mask-border-outset", important);
        this.appendDeclarationIfNotKeyword(keyword, wri, context, "mask-border-repeat", important);
        this.appendDeclarationIfNotKeyword(keyword, wri, context, "mask-border-mode", important);
    }

    private void serializeMaskBorderIfNotInitial(BufferSimpleWriter wri, DeclarationFormattingContext context, boolean important) {
        this.appendDeclarationIfNotInitial(wri, context, "mask-border-source", important);
        this.appendDeclarationIfNotInitial(wri, context, "mask-border-slice", important);
        this.appendDeclarationIfNotInitial(wri, context, "mask-border-width", important);
        this.appendDeclarationIfNotInitial(wri, context, "mask-border-outset", important);
        this.appendDeclarationIfNotInitial(wri, context, "mask-border-repeat", important);
        this.appendDeclarationIfNotInitial(wri, context, "mask-border-mode", important);
    }
}

