/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer;

import java.io.File;
import java.util.LinkedList;
import org.catacombae.hfsexplorer.fs.ProgressMonitor;

public interface ExtractProgressMonitor
extends ProgressMonitor {
    public void updateCalculateDir(String var1);

    public void updateTotalProgress(double var1, String var3);

    public void updateCurrentDir(String var1);

    public void updateCurrentFile(String var1, long var2);

    public void setDataSize(long var1);

    public CreateDirectoryFailedAction createDirectoryFailed(String var1, File var2);

    public CreateFileFailedAction createFileFailed(String var1, File var2);

    public DirectoryExistsAction directoryExists(File var1);

    public FileExistsAction fileExists(File var1);

    public String displayRenamePrompt(String var1, File var2);

    public ExtractProperties getExtractProperties();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileExistsAction {
        PROMPT_USER,
        SKIP_FILE,
        SKIP_DIRECTORY,
        OVERWRITE,
        OVERWRITE_ALL,
        RENAME,
        AUTO_RENAME,
        CANCEL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DirectoryExistsAction {
        PROMPT_USER,
        CONTINUE,
        SKIP_DIRECTORY,
        RENAME,
        AUTO_RENAME,
        CANCEL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CreateFileFailedAction {
        PROMPT_USER,
        SKIP_FILE,
        SKIP_DIRECTORY,
        RENAME,
        AUTO_RENAME,
        CANCEL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CreateDirectoryFailedAction {
        PROMPT_USER,
        SKIP_DIRECTORY,
        RENAME,
        AUTO_RENAME,
        CANCEL;

    }

    public static class ExtractProperties {
        private final LinkedList<ExtractPropertiesListener> listeners = new LinkedList();
        private volatile CreateDirectoryFailedAction createDirAction = CreateDirectoryFailedAction.PROMPT_USER;
        private volatile CreateFileFailedAction createFileAction = CreateFileFailedAction.PROMPT_USER;
        private volatile DirectoryExistsAction dirExistsAction = DirectoryExistsAction.PROMPT_USER;
        private volatile FileExistsAction fileExistsAction = FileExistsAction.PROMPT_USER;

        public CreateDirectoryFailedAction getCreateDirectoryFailedAction() {
            return this.createDirAction;
        }

        public CreateFileFailedAction getCreateFileFailedAction() {
            return this.createFileAction;
        }

        public DirectoryExistsAction getDirectoryExistsAction() {
            return this.dirExistsAction;
        }

        public FileExistsAction getFileExistsAction() {
            return this.fileExistsAction;
        }

        public void setCreateDirectoryFailedAction(CreateDirectoryFailedAction action) {
            this.createDirAction = action;
            this.notifyListeners((Object)action);
        }

        public void setCreateFileFailedAction(CreateFileFailedAction action) {
            this.createFileAction = action;
            this.notifyListeners((Object)action);
        }

        public void setDirectoryExistsAction(DirectoryExistsAction action) {
            this.dirExistsAction = action;
            this.notifyListeners((Object)action);
        }

        public void setFileExistsAction(FileExistsAction action) {
            this.fileExistsAction = action;
            this.notifyListeners((Object)action);
        }

        public void addListener(ExtractPropertiesListener listener) {
            this.listeners.addLast(listener);
        }

        private void notifyListeners(Object changedProperty) {
            for (ExtractPropertiesListener listener : this.listeners) {
                try {
                    listener.propertyChanged(changedProperty);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static interface ExtractPropertiesListener {
        public void propertyChanged(Object var1);
    }
}

