/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.filters;

import ghidra.features.bsim.gui.filters.BSimFilterType;
import ghidra.features.bsim.query.client.IDSQLResolution;
import ghidra.features.bsim.query.client.SQLEffects;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.elastic.ElasticEffects;
import ghidra.features.bsim.query.elastic.ElasticException;
import ghidra.features.bsim.query.elastic.IDElasticResolution;
import ghidra.features.bsim.query.protocol.FilterAtom;
import java.sql.SQLException;

public class PathStartsBSimFilterType
extends BSimFilterType {
    public static final String XML_VALUE = "pathstarts";

    public PathStartsBSimFilterType() {
        super("Path starts with", XML_VALUE, "path");
    }

    @Override
    public void gatherSQLEffect(SQLEffects effect, FilterAtom atom, IDSQLResolution resolution) throws SQLException {
        if (atom.value.length() > 0) {
            effect.setExeTable();
            effect.setPathTable();
            StringBuilder buf = new StringBuilder();
            buf.append("position( '").append(atom.value).append("' in pathtable.val) = 1");
            effect.addWhere(this, buf.toString());
        }
    }

    @Override
    public void gatherElasticEffect(ElasticEffects effect, FilterAtom atom, IDElasticResolution resolution) throws ElasticException {
        effect.addDocValue("String path = doc['path'].size() == 0 ? null : doc['path'].value; ");
        String argName = effect.assignArgument();
        effect.addScriptElement(this, "(path != null) && path.startsWith(params." + argName + ")");
        effect.addParam(argName, atom.value);
    }

    @Override
    public boolean evaluate(ExecutableRecord rec, String value) {
        if (rec.getPath() == null) {
            return false;
        }
        return rec.getPath().startsWith(value);
    }

    @Override
    public String normalizeValue(String value) {
        if ((value = value.trim()).isBlank()) {
            return null;
        }
        int pos = 0;
        int posend = value.length();
        if (value.charAt(0) == '/') {
            pos = 1;
        }
        if (value.charAt(posend - 1) == '/') {
            --posend;
        }
        if (posend <= pos) {
            return null;
        }
        value = value.substring(pos, posend);
        return value;
    }

    @Override
    public boolean isValidValue(String value) {
        return this.normalizeValue(value) != null;
    }

    @Override
    public IDSQLResolution generateIDSQLResolution(FilterAtom atom) {
        return null;
    }
}

