/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import generic.lsh.vector.LSHVectorFactory;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.protocol.QueryResponseRecord;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;

public class ResponsePrewarm
extends QueryResponseRecord {
    public int blockCount = -1;
    public boolean operationSupported = true;

    public ResponsePrewarm() {
        super("responseprewarm");
    }

    @Override
    public void saveXml(Writer fwrite) throws IOException {
        fwrite.append('<').append(this.name);
        fwrite.append(" support=\"").append(SpecXmlUtils.encodeBoolean((boolean)this.operationSupported));
        fwrite.append("\">\n");
        Integer.toString(this.blockCount);
        fwrite.append("</").append(this.name).append(">\n");
    }

    @Override
    public void restoreXml(XmlPullParser parser, LSHVectorFactory vectorFactory) throws LSHException {
        XmlElement el = parser.start(new String[]{this.name});
        this.operationSupported = SpecXmlUtils.decodeBoolean((String)el.getAttribute("support"));
        this.blockCount = SpecXmlUtils.decodeInt((String)parser.end().getText());
    }
}

