/*
 * Decompiled with CFR 0.152.
 */
package sarif.export.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.ISF.IsfFunction;
import ghidra.program.model.data.ISF.IsfUtilities;
import ghidra.program.model.data.ParameterDefinition;

public class ExtIsfFunction
extends IsfFunction {
    String comment;
    String callingConventionName;
    boolean hasVarArgs;
    boolean hasNoReturn;
    JsonObject retType;
    JsonArray params;

    public ExtIsfFunction(FunctionDefinition funcDef) {
        super(funcDef);
        ParameterDefinition[] vars;
        this.comment = funcDef.getDescription();
        this.callingConventionName = funcDef.getCallingConventionName();
        this.hasVarArgs = funcDef.hasVarArgs();
        this.hasNoReturn = funcDef.hasNoReturn();
        this.retType = new JsonObject();
        DataType rt = funcDef.getReturnType();
        if (rt != null && rt != DataType.DEFAULT) {
            this.retType.addProperty("name", rt.getName());
            this.retType.addProperty("location", rt.getCategoryPath().getPath());
            this.retType.addProperty("kind", IsfUtilities.getKind((DataType)rt));
            this.retType.addProperty("size", (Number)rt.getLength());
        }
        this.params = new JsonArray();
        for (ParameterDefinition var : vars = funcDef.getArguments()) {
            JsonObject param = new JsonObject();
            this.params.add((JsonElement)param);
            DataType dt = var.getDataType();
            param.addProperty("name", var.getName());
            param.addProperty("size", (Number)var.getLength());
            param.addProperty("ordinal", (Number)var.getOrdinal());
            param.addProperty("comment", var.getComment());
            if (dt == null) continue;
            param.addProperty("name", dt.getName());
            param.addProperty("location", dt.getCategoryPath().getPath());
            param.addProperty("kind", IsfUtilities.getKind((DataType)dt));
        }
    }
}

