/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import ghidra.app.plugin.core.decompile.actions.PCodeDfgGraphTask;
import ghidra.app.plugin.core.decompile.actions.PCodeDfgGraphType;
import ghidra.app.services.GraphDisplayBroker;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.PcodeBlock;
import ghidra.program.model.pcode.PcodeBlockBasic;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.PcodeOpAST;
import ghidra.program.model.pcode.VarnodeAST;
import ghidra.service.graph.AttributedEdge;
import ghidra.service.graph.AttributedVertex;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PCodeCombinedGraphTask
extends PCodeDfgGraphTask {
    public PCodeCombinedGraphTask(PluginTool tool, GraphDisplayBroker graphService, HighFunction hfunction) {
        super(tool, graphService, hfunction);
    }

    @Override
    protected void buildGraph() {
        AttributedEdge edge;
        HashMap<Integer, AttributedVertex> vertices = new HashMap<Integer, AttributedVertex>();
        Iterator<PcodeOpAST> opiter = this.getPcodeOpIterator();
        HashMap<PcodeOpAST, AttributedVertex> map = new HashMap<PcodeOpAST, AttributedVertex>();
        while (opiter.hasNext()) {
            AttributedVertex outv;
            PcodeOpAST op = opiter.next();
            AttributedVertex o = this.createOpVertex(op);
            map.put(op, o);
            for (int i = 0; i < op.getNumInputs(); ++i) {
                VarnodeAST vn;
                if (i == 0 && (op.getOpcode() == 2 || op.getOpcode() == 3) || i == 1 && op.getOpcode() == 61 || (vn = (VarnodeAST)op.getInput(i)) == null) continue;
                AttributedVertex v = this.getVarnodeVertex(vertices, vn);
                this.createEdge(v, o);
            }
            VarnodeAST outvn = (VarnodeAST)op.getOutput();
            if (outvn == null || (outv = this.getVarnodeVertex(vertices, outvn)) == null) continue;
            this.createEdge(o, outv);
        }
        opiter = this.getPcodeOpIterator();
        HashSet<PcodeBlockBasic> seenParents = new HashSet<PcodeBlockBasic>();
        HashMap<PcodeBlockBasic, AttributedVertex> first = new HashMap<PcodeBlockBasic, AttributedVertex>();
        HashMap<PcodeBlockBasic, AttributedVertex> last = new HashMap<PcodeBlockBasic, AttributedVertex>();
        while (opiter.hasNext()) {
            PcodeOpAST op = opiter.next();
            PcodeBlockBasic parent = op.getParent();
            if (seenParents.contains(parent)) continue;
            Iterator iterator = parent.getIterator();
            PcodeOp prev = null;
            PcodeOp next = null;
            while (iterator.hasNext()) {
                next = (PcodeOp)iterator.next();
                if (prev == null && map.containsKey(next)) {
                    first.put(parent, (AttributedVertex)map.get(next));
                }
                if (prev != null && map.containsKey(prev) && map.containsKey(next)) {
                    edge = this.createEdge((AttributedVertex)map.get(prev), (AttributedVertex)map.get(next));
                    edge.setEdgeType(PCodeDfgGraphType.WITHIN_BLOCK);
                }
                prev = next;
            }
            if (next != null && map.containsKey(next)) {
                last.put(parent, (AttributedVertex)map.get(next));
            }
            seenParents.add(parent);
        }
        Set keySet = first.keySet();
        for (PcodeBlock block : keySet) {
            for (int i = 0; i < block.getInSize(); ++i) {
                PcodeBlock in = block.getIn(i);
                if (!last.containsKey(in)) continue;
                edge = this.createEdge((AttributedVertex)last.get(in), (AttributedVertex)first.get(block));
                edge.setEdgeType(PCodeDfgGraphType.BETWEEN_BLOCKS);
            }
        }
    }
}

