/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.plugin.core.decompile.DecompilePlugin;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.ConvertConstantAction;
import ghidra.app.plugin.core.decompile.actions.ConvertConstantTask;
import ghidra.app.util.bean.SetEquateDialog;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.util.HelpLocation;

public class SetEquateAction
extends ConvertConstantAction {
    public SetEquateAction(DecompilePlugin plugin) {
        super(plugin, "Set Equate", 0);
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionSetEquate"));
        this.setPopupMenuData(new MenuData(new String[]{"Set Equate..."}, "Decompile"));
        this.setKeyBindingData(new KeyBindingData(69, 0));
    }

    @Override
    public String getMenuPrefix() {
        return null;
    }

    @Override
    public String getMenuDisplay(long value, int size, boolean isSigned, Program program) {
        return null;
    }

    @Override
    public String getEquateName(long value, int size, boolean isSigned, Program program) {
        if (program == null) {
            return null;
        }
        Scalar scalar = new Scalar(size * 8, value, isSigned);
        SetEquateDialog dialog = new SetEquateDialog(this.plugin.getTool(), program, scalar);
        dialog.disableHasSelection();
        int res = dialog.showSetDialog();
        String name = null;
        if (res != 0) {
            name = dialog.getEquateName();
        }
        dialog.dispose();
        return name;
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        ConvertConstantTask task = this.establishTask(context, false);
        return task != null;
    }
}

