/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.C13CrossScopeExport;
import ghidra.app.util.bin.format.pdb2.pdbreader.C13Section;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class CrossScopeExportsC13Section
extends C13Section {
    private List<C13CrossScopeExport> crossScopeExports = new ArrayList<C13CrossScopeExport>();

    static CrossScopeExportsC13Section parse(PdbByteReader reader, boolean ignore, TaskMonitor monitor) throws PdbException, CancelledException {
        return new CrossScopeExportsC13Section(reader, ignore, monitor);
    }

    private CrossScopeExportsC13Section(PdbByteReader reader, boolean ignore, TaskMonitor monitor) throws CancelledException, PdbException {
        super(ignore);
        while (reader.numRemaining() >= C13CrossScopeExport.getBaseRecordSize()) {
            monitor.checkCancelled();
            C13CrossScopeExport crossExport = new C13CrossScopeExport(reader);
            this.crossScopeExports.add(crossExport);
        }
        if (reader.hasMore()) {
            Msg.debug(CrossScopeExportsC13Section.class, (Object)String.format("Num Extra C13CrossScopeExports bytes: %d", reader.numRemaining()));
        }
    }

    public List<C13CrossScopeExport> getCrossScopeExports() {
        return this.crossScopeExports;
    }

    public String toString() {
        return String.format("%s: num cross-scope exports = %d", this.getClass().getSimpleName(), this.crossScopeExports.size());
    }

    @Override
    protected void dumpInternal(Writer writer, TaskMonitor monitor) throws IOException, CancelledException {
        for (C13CrossScopeExport crossScopeExport : this.crossScopeExports) {
            monitor.checkCancelled();
            writer.write(crossScopeExport.toString());
            writer.write(10);
        }
    }
}

