/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.data.CheckinHandler;
import ghidra.framework.main.datatree.VersionControlTask;
import ghidra.framework.model.DomainFile;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.Msg;
import ghidra.util.VersionExceptionHandler;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.IOException;
import java.util.List;

public class CheckInTask
extends VersionControlTask
implements CheckinHandler {
    private DomainFile df;
    private boolean newFile;
    private TaskMonitor monitor;

    public CheckInTask(PluginTool tool, List<DomainFile> list, Component parent) {
        super("Check In", tool, list, parent);
    }

    private void promptUser() throws CancelledException {
        if (this.newFile) {
            this.newFile = false;
            this.monitor.checkCancelled();
            if (this.actionID != 1) {
                this.showDialog(false, this.df);
                if (this.actionID == 2) {
                    this.monitor.cancel();
                    Msg.info((Object)this, (Object)"Check In was canceled");
                    throw new CancelledException();
                }
            }
        }
    }

    public void run(TaskMonitor myMonitor) {
        this.monitor = myMonitor;
        myMonitor.setMessage("Examining selected file(s)");
        String currentName = null;
        try {
            for (int i = 0; i < this.list.size() && this.actionID != 2; ++i) {
                this.df = (DomainFile)this.list.get(i);
                currentName = this.df.getName();
                this.newFile = true;
                if (i != 0) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e2) {
                        break;
                    }
                }
                myMonitor.setMessage("Initiating Check In for " + currentName);
                try {
                    this.df.checkin(this, myMonitor);
                }
                catch (VersionException e) {
                    VersionExceptionHandler.showVersionError(this.parent, this.df.getName(), this.df.getContentType(), "Checkin", e);
                }
                if (!myMonitor.isCancelled()) {
                    continue;
                }
                break;
            }
        }
        catch (CancelledException e) {
            Msg.info((Object)this, (Object)"Check In Process was canceled");
            this.wasCanceled = true;
        }
        catch (IOException e) {
            RepositoryAdapter repo = this.df.getParent().getProjectData().getRepository();
            ClientUtil.handleException((RepositoryAdapter)repo, (Exception)e, (String)"Check In Process", (Component)this.parent);
        }
    }

    @Override
    public String getComment() throws CancelledException {
        this.promptUser();
        return this.comments;
    }

    @Override
    public boolean keepCheckedOut() throws CancelledException {
        this.promptUser();
        return this.keepCheckedOut;
    }

    @Override
    public boolean createKeepFile() throws CancelledException {
        this.promptUser();
        return this.createKeep;
    }
}

