/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import ghidra.app.plugin.core.debug.gui.action.NoneLocationTrackingSpec;
import ghidra.app.plugin.core.debug.gui.action.PCByRegisterLocationTrackingSpec;
import ghidra.app.plugin.core.debug.gui.action.PCByStackLocationTrackingSpec;
import ghidra.app.plugin.core.debug.gui.action.PCLocationTrackingSpec;
import ghidra.app.plugin.core.debug.gui.action.SPLocationTrackingSpec;
import ghidra.debug.api.action.LocationTrackingSpec;
import ghidra.debug.api.action.LocationTrackingSpecFactory;
import ghidra.framework.plugintool.PluginTool;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class BasicLocationTrackingSpecFactory
implements LocationTrackingSpecFactory {
    public static final List<LocationTrackingSpec> ALL = List.of(NoneLocationTrackingSpec.INSTANCE, PCLocationTrackingSpec.INSTANCE, PCByRegisterLocationTrackingSpec.INSTANCE, PCByStackLocationTrackingSpec.INSTANCE, SPLocationTrackingSpec.INSTANCE);
    public static final Map<String, LocationTrackingSpec> BY_CONFIG_NAME = ALL.stream().collect(Collectors.toUnmodifiableMap(LocationTrackingSpec::getConfigName, Function.identity()));

    public List<LocationTrackingSpec> getSuggested(PluginTool tool) {
        return ALL;
    }

    public LocationTrackingSpec parseSpec(String name) {
        return BY_CONFIG_NAME.get(name);
    }
}

