/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.filter;

import docking.widgets.filter.TermSplitter;
import ghidra.util.StringUtilities;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractRegexBasedTermSplitter
implements TermSplitter {
    private final Pattern pattern;
    private static final String[] EMPTY = new String[0];

    private static String generatePattern(String delim) {
        return "\\s*" + Pattern.quote(delim) + "\\s*(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)";
    }

    public AbstractRegexBasedTermSplitter(String delimiter) {
        this.pattern = Pattern.compile(AbstractRegexBasedTermSplitter.generatePattern(delimiter));
    }

    @Override
    public String[] split(String input) {
        if (StringUtils.isBlank((CharSequence)input)) {
            return EMPTY;
        }
        String[] terms = this.pattern.split(input);
        for (int i = 0; i < terms.length; ++i) {
            terms[i] = StringUtilities.extractFromDoubleQuotes((String)terms[i]);
        }
        return terms;
    }
}

