/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.action.KeyBindingData;
import generic.theme.GIcon;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.app.plugin.core.compositeeditor.CompositeViewerDataTypeManager;
import javax.swing.Icon;

public class RedoChangeAction
extends CompositeEditorTableAction {
    public static String DESCRIPTION = "Redo Change";
    public static final String ACTION_NAME = "Redo Editor Change";
    private static final String GROUP_NAME = "1_UNDOREDO_EDITOR_ACTION";
    private static final Icon ICON = new GIcon("icon.redo");
    private static final String[] POPUP_PATH = new String[]{DESCRIPTION};

    public RedoChangeAction(CompositeEditorProvider<?, ?> provider) {
        super(provider, ACTION_NAME, GROUP_NAME, POPUP_PATH, null, ICON);
        this.setKeyBindingData(new KeyBindingData("ctrl shift Z"));
        this.setDescription("Redo editor change");
    }

    public void actionPerformed(ActionContext context) {
        if (!this.isEnabledForContext(context)) {
            return;
        }
        CompositeViewerDataTypeManager viewDTM = this.model.getViewDataTypeManager();
        viewDTM.redo();
        this.model.clearStatus();
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (this.hasIncompleteFieldEntry()) {
            return false;
        }
        CompositeViewerDataTypeManager viewDTM = this.model.getViewDataTypeManager();
        boolean canRedo = viewDTM.canRedo();
        this.setEnabled(canRedo);
        String description = DESCRIPTION + (String)(canRedo ? ": " + viewDTM.getRedoName() : "");
        this.setDescription(description);
        return canRedo;
    }
}

