/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.data;

import docking.DialogComponentProvider;
import ghidra.app.services.DataTypeManagerService;
import ghidra.app.util.datatype.DataTypeSelectionEditor;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Undefined1DataType;
import ghidra.program.model.data.Union;
import ghidra.program.model.listing.Program;
import ghidra.util.DateUtils;
import ghidra.util.HelpLocation;
import ghidra.util.MessageType;
import ghidra.util.data.DataTypeParser;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;

public class EditDataFieldDialog
extends DialogComponentProvider {
    private static boolean addAddress;
    private static boolean addDate;
    private JTextField nameField;
    private JTextField commentField;
    private DataTypeSelectionEditor dataTypeEditor;
    private JCheckBox addressCheckBox;
    private JCheckBox dateCheckBox;
    private PluginTool tool;
    private DataTypeManagerService dtmService;
    private Composite composite;
    private Address address;
    private int ordinal;
    private Program program;

    public EditDataFieldDialog(PluginTool tool, DataTypeManagerService dtmService, Composite composite, Program program, Address address, int ordinal) {
        super("Edit Field Dialog", true, true, true, false);
        this.tool = tool;
        this.dtmService = dtmService;
        this.composite = composite;
        this.program = program;
        this.address = address;
        this.ordinal = ordinal;
        this.setTitle(this.generateTitle());
        this.addWorkPanel(this.buildMainPanel());
        this.initializeFields();
        this.setFocusComponent(this.nameField);
        this.setHelpLocation(new HelpLocation("DataPlugin", "Edit_Field_Dialog"));
        this.addOKButton();
        this.addCancelButton();
    }

    public void dispose() {
        super.dispose();
        this.tool = null;
        this.program = null;
    }

    public DataType getNewDataType() {
        DataType newDataType = this.dataTypeEditor.getCellEditorValueAsDataType();
        return newDataType != null ? newDataType : new Undefined1DataType();
    }

    public String getNameText() {
        return this.nameField.getText();
    }

    public void setNameText(String newName) {
        this.nameField.setText(newName);
    }

    public String getCommentText() {
        return this.commentField.getText();
    }

    public void setCommentText(String newComment) {
        this.commentField.setText(newComment);
    }

    public void setDataType(DataType dataType) {
        this.dataTypeEditor.setCellEditorValue(dataType);
    }

    private void initializeFields() {
        String name = this.getFieldName();
        this.nameField.setText(name);
        String comment = this.getComment();
        this.commentField.setText(comment);
        DataType dt = this.getComponentDataType();
        this.dataTypeEditor.setCellEditorValue(dt);
        if (addAddress) {
            this.addressCheckBox.setSelected(true);
            this.addTextToComment(this.getCurrentAddressString());
        }
        if (addDate) {
            this.dateCheckBox.setSelected(true);
            this.addTextToComment(this.getTodaysDate());
        }
    }

    private String getComment() {
        if (this.hasNoDataTypeComponent()) {
            return "";
        }
        DataTypeComponent dtc = this.composite.getComponent(this.ordinal);
        String comment = dtc.getComment();
        if (StringUtils.isBlank((CharSequence)comment)) {
            return "";
        }
        return comment;
    }

    private String getFieldName() {
        if (this.hasNoDataTypeComponent()) {
            return "";
        }
        DataTypeComponent dtc = this.composite.getComponent(this.ordinal);
        String fieldName = dtc.getFieldName();
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            return "";
        }
        return fieldName;
    }

    private boolean hasNoDataTypeComponent() {
        return this.ordinal >= this.composite.getNumComponents();
    }

    protected void okCallback() {
        if (this.updateComponent()) {
            this.close();
        }
    }

    private boolean updateComponent() {
        if (!this.hasChanges()) {
            return true;
        }
        UpdateDataComponentCommand cmd = new UpdateDataComponentCommand();
        if (!this.tool.execute((Command)cmd, (DomainObject)this.program)) {
            this.setStatusText(cmd.getStatusMsg(), MessageType.ERROR);
            return false;
        }
        return true;
    }

    private boolean hasChanges() {
        return this.hasNameChange() || this.hasCommentChange() || this.hasDataTypeChange();
    }

    private boolean hasCommentChange() {
        String oldComment = this.getComment();
        String newComment = this.getNewFieldComment();
        if (StringUtils.isBlank((CharSequence)newComment) && StringUtils.isBlank((CharSequence)oldComment)) {
            return false;
        }
        return !newComment.equals(oldComment);
    }

    private DataType getComponentDataType() {
        if (this.hasNoDataTypeComponent()) {
            return DataType.DEFAULT;
        }
        DataTypeComponent dtc = this.composite.getComponent(this.ordinal);
        return dtc.getDataType();
    }

    boolean hasDataTypeChange() {
        DataType oldDt = this.getComponentDataType();
        DataType newDt = this.dataTypeEditor.getCellEditorValueAsDataType();
        return newDt != null && !newDt.equals((Object)oldDt);
    }

    boolean hasNameChange() {
        String currentName;
        String newName = this.getNewFieldName();
        return !newName.equals(currentName = this.getFieldName());
    }

    private String getNewFieldName() {
        return this.nameField.getText().trim();
    }

    private String getNewFieldComment() {
        return this.commentField.getText().trim();
    }

    private JPanel buildMainPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.buildNameValuePanel(), "North");
        panel.add((Component)this.buildCheckboxPanel(), "South");
        return panel;
    }

    private JPanel buildCheckboxPanel() {
        JPanel panel = new JPanel(new FlowLayout(1, 30, 0));
        this.addressCheckBox = new JCheckBox("Add Current Address");
        this.addressCheckBox.addActionListener(this::addressCheckBoxChanged);
        this.dateCheckBox = new JCheckBox("Add Today's Date");
        this.dateCheckBox.addActionListener(this::dateCheckBoxChanged);
        panel.add(this.addressCheckBox);
        panel.add(this.dateCheckBox);
        return panel;
    }

    private JPanel buildNameValuePanel() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(10, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.nameField = new JTextField(20);
        this.nameField.setEditable(true);
        this.nameField.addActionListener(e -> this.okCallback());
        this.commentField = new JTextField(20);
        this.commentField.setEditable(true);
        this.commentField.addActionListener(e -> this.okCallback());
        panel.add(new JLabel("Field Name:", 2));
        panel.add(this.nameField);
        panel.add(new JLabel("Datatype:", 2));
        panel.add(this.buildDataTypeChooserPanel());
        panel.add(new JLabel("Comment:", 2));
        panel.add(this.commentField);
        return panel;
    }

    private JPanel buildDataTypeChooserPanel() {
        JPanel panel = new JPanel(new BorderLayout(10, 0));
        DataTypeManager dtm = this.composite.getDataTypeManager();
        this.dataTypeEditor = new DataTypeSelectionEditor(dtm, this.dtmService, DataTypeParser.AllowedDataTypes.ALL);
        JComponent editorComponent = this.dataTypeEditor.getEditorComponent();
        panel.add((Component)editorComponent, "Center");
        return panel;
    }

    private String generateTitle() {
        String compositeName = this.composite.getName();
        return "Edit " + compositeName + ", Field " + this.ordinal;
    }

    private void dateCheckBoxChanged(ActionEvent e) {
        String today = this.getTodaysDate();
        addDate = this.dateCheckBox.isSelected();
        if (addDate) {
            this.addTextToComment(today);
        } else {
            this.removeTextFromComment(today);
        }
    }

    private void addressCheckBoxChanged(ActionEvent e) {
        String addressString = this.getCurrentAddressString();
        addAddress = this.addressCheckBox.isSelected();
        if (addAddress) {
            this.addTextToComment(addressString);
        } else {
            this.removeTextFromComment(addressString);
        }
    }

    private void removeTextFromComment(String text) {
        String comment = this.commentField.getText().trim();
        int index = comment.indexOf(text);
        if (index < 0) {
            return;
        }
        comment = comment.replaceAll(text + "\\s*", "");
        this.commentField.setText(comment.trim());
    }

    private String getTodaysDate() {
        return DateUtils.formatCompactDate((Date)new Date());
    }

    private String getCurrentAddressString() {
        return this.address.toString();
    }

    private void addTextToComment(String text) {
        Object comment = this.commentField.getText().trim();
        if (((String)comment).contains(text)) {
            return;
        }
        if (!((String)comment).isBlank()) {
            comment = (String)comment + " ";
        }
        comment = (String)comment + text;
        this.commentField.setText(((String)comment).trim());
    }

    public String getDataTypeText() {
        return this.dataTypeEditor.getCellEditorValueAsText();
    }

    public DataTypeSelectionEditor getDataTypeEditor() {
        return this.dataTypeEditor;
    }

    private class UpdateDataComponentCommand
    implements Command<Program> {
        private String statusMessage = null;

        private UpdateDataComponentCommand() {
        }

        public boolean applyTo(Program p) {
            this.maybeAdjustStructure();
            if (!this.updateDataType()) {
                return false;
            }
            if (!this.updateName()) {
                return false;
            }
            return this.updateComment();
        }

        private void maybeAdjustStructure() {
            Composite composite = EditDataFieldDialog.this.composite;
            if (!(composite instanceof Structure)) {
                return;
            }
            Structure struct = (Structure)composite;
            this.growStructureAsNeeded(struct);
            this.ensureDataTypeComponentRecordExists(struct);
        }

        private void growStructureAsNeeded(Structure struct) {
            int n = EditDataFieldDialog.this.composite.getNumComponents();
            if (EditDataFieldDialog.this.ordinal >= n) {
                int amount = EditDataFieldDialog.this.ordinal - n;
                struct.growStructure(amount);
            }
        }

        private void ensureDataTypeComponentRecordExists(Structure struct) {
            DataType editorDt;
            DataTypeComponent dtc = EditDataFieldDialog.this.composite.getComponent(EditDataFieldDialog.this.ordinal);
            if (dtc.getDataType() != DataType.DEFAULT) {
                return;
            }
            Undefined1DataType newtype = new Undefined1DataType();
            DataTypeComponent newDtc = struct.replaceAtOffset(dtc.getOffset(), (DataType)newtype, 1, "tempName", "Created by Edit Data Field action");
            DataType oldDt = dtc.getDataType();
            if (oldDt.equals((Object)(editorDt = EditDataFieldDialog.this.dataTypeEditor.getCellEditorValueAsDataType()))) {
                EditDataFieldDialog.this.dataTypeEditor.setCellEditorValue(newDtc.getDataType());
            }
        }

        private boolean updateName() {
            if (!EditDataFieldDialog.this.hasNameChange()) {
                return true;
            }
            DataTypeComponent dtc = EditDataFieldDialog.this.composite.getComponent(EditDataFieldDialog.this.ordinal);
            try {
                dtc.setFieldName(EditDataFieldDialog.this.getNewFieldName());
                return true;
            }
            catch (DuplicateNameException e) {
                this.statusMessage = "Duplicate field name";
                return false;
            }
        }

        private boolean updateComment() {
            DataTypeComponent dtc = EditDataFieldDialog.this.composite.getComponent(EditDataFieldDialog.this.ordinal);
            if (EditDataFieldDialog.this.hasCommentChange()) {
                dtc.setComment(EditDataFieldDialog.this.getNewFieldComment());
            }
            return true;
        }

        private boolean updateDataType() {
            if (!EditDataFieldDialog.this.hasDataTypeChange()) {
                return true;
            }
            try {
                Composite composite = EditDataFieldDialog.this.composite;
                if (composite instanceof Structure) {
                    Structure struct = (Structure)composite;
                    this.updateStructure(struct);
                } else {
                    composite = EditDataFieldDialog.this.composite;
                    if (composite instanceof Union) {
                        Union union = (Union)composite;
                        this.updateUnion(union);
                    }
                }
                return true;
            }
            catch (DuplicateNameException e) {
                this.statusMessage = "Duplicate field name";
                return false;
            }
            catch (Exception e) {
                this.statusMessage = e.getMessage();
                return false;
            }
        }

        private void updateStructure(Structure struct) {
            DataType newDt = EditDataFieldDialog.this.dataTypeEditor.getCellEditorValueAsDataType();
            DataTypeComponent dtc = EditDataFieldDialog.this.composite.getComponent(EditDataFieldDialog.this.ordinal);
            DataType resolvedDt = EditDataFieldDialog.this.program.getDataTypeManager().resolve(newDt, null);
            if (resolvedDt == DataType.DEFAULT) {
                struct.clearComponent(EditDataFieldDialog.this.ordinal);
                return;
            }
            DataTypeInstance dti = DataTypeInstance.getDataTypeInstance((DataType)resolvedDt, (int)-1, (boolean)false);
            DataType dataType = dti.getDataType();
            int length = dti.getLength();
            String fieldName = dtc.getFieldName();
            String comment = dtc.getComment();
            dtc = struct.replace(EditDataFieldDialog.this.ordinal, dataType, length, fieldName, comment);
        }

        private void updateUnion(Union union) throws DuplicateNameException {
            DataType newDt = EditDataFieldDialog.this.dataTypeEditor.getCellEditorValueAsDataType();
            DataTypeComponent dtc = EditDataFieldDialog.this.composite.getComponent(EditDataFieldDialog.this.ordinal);
            DataType resolvedDt = EditDataFieldDialog.this.program.getDataTypeManager().resolve(newDt, null);
            String comment = dtc.getComment();
            String fieldName = dtc.getFieldName();
            union.insert(EditDataFieldDialog.this.ordinal, resolvedDt);
            union.delete(EditDataFieldDialog.this.ordinal + 1);
            dtc = union.getComponent(EditDataFieldDialog.this.ordinal);
            dtc.setComment(comment);
            dtc.setFieldName(fieldName);
        }

        public String getStatusMsg() {
            return this.statusMessage;
        }

        public String getName() {
            return "Update Structure Field";
        }
    }
}

