/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.bin.ByteArrayProvider;
import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FactoryStructureDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;

public class ElfDataType
extends FactoryStructureDataType {
    private static final long serialVersionUID = 1L;

    public ElfDataType() {
        this(null);
    }

    public ElfDataType(DataTypeManager dtm) {
        super("ELF", dtm);
    }

    public String getMnemonic(Settings settings) {
        return "ELF";
    }

    public String getDescription() {
        return "ELF Data Type";
    }

    protected void populateDynamicStructure(MemBuffer buf, Structure struct) {
        try {
            Memory memory = buf.getMemory();
            MemoryBlock block = memory.getBlock(buf.getAddress());
            byte[] bytes = new byte[(int)block.getSize()];
            block.getBytes(block.getStart(), bytes);
            ByteArrayProvider bap = new ByteArrayProvider(bytes);
            ElfHeader elf = new ElfHeader(bap, null);
            elf.parse();
            struct.add(elf.toDataType());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DataType clone(DataTypeManager dtm) {
        return new ElfDataType(dtm);
    }
}

