/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.base.replace.items;

import ghidra.app.services.DataTypeManagerService;
import ghidra.features.base.quickfix.QuickFixStatus;
import ghidra.features.base.replace.RenameQuickFix;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.MissingBuiltInDataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import java.util.Map;

public class RenameDataTypeQuickFix
extends RenameQuickFix {
    private DataType dataType;

    public RenameDataTypeQuickFix(Program program, DataType dataType, String newName) {
        super(program, dataType.getName(), newName);
        this.dataType = dataType;
        if (!this.canRename()) {
            this.setStatus(QuickFixStatus.ERROR, "This datatype doesn't support renaming");
        }
        this.checkDuplicate();
    }

    private void checkDuplicate() {
        CategoryPath categoryPath = this.dataType.getCategoryPath();
        DataTypeManager dtm = this.dataType.getDataTypeManager();
        Category category = dtm.getCategory(categoryPath);
        DataType existing = category.getDataType(this.replacement);
        if (existing != null) {
            this.setStatus(QuickFixStatus.WARNING, "Datatype with name \"" + this.replacement + "\" already exists in category \"" + category.getCategoryPathName() + "\"");
        }
    }

    @Override
    public String getItemType() {
        return "Datatype";
    }

    @Override
    public Address getAddress() {
        return null;
    }

    private boolean canRename() {
        return !(this.dataType instanceof BuiltInDataType) && !(this.dataType instanceof MissingBuiltInDataType) && !(this.dataType instanceof Array) && !(this.dataType instanceof Pointer);
    }

    @Override
    public String getPath() {
        return this.dataType.getCategoryPath().getPath();
    }

    @Override
    public String doGetCurrent() {
        if (this.dataType.isDeleted()) {
            return null;
        }
        return this.dataType.getName();
    }

    @Override
    public void execute() {
        try {
            this.dataType.setName(this.replacement);
        }
        catch (Exception e) {
            this.setStatus(QuickFixStatus.ERROR, "Rename datatype failed: " + e.getMessage());
        }
    }

    @Override
    public ProgramLocation getProgramLocation() {
        return null;
    }

    @Override
    protected boolean navigateSpecial(ServiceProvider services, boolean fromSelectionChange) {
        DataTypeManagerService dtmService = (DataTypeManagerService)services.getService(DataTypeManagerService.class);
        if (dtmService == null) {
            return false;
        }
        dtmService.setDataTypeSelected(this.dataType);
        if (!fromSelectionChange) {
            dtmService.edit(this.dataType);
        }
        return true;
    }

    @Override
    public Map<String, String> getCustomToolTipData() {
        return Map.of("Category", this.dataType.getCategoryPath().toString());
    }
}

