/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.bytesearch;

import ghidra.util.bytesearch.Pattern;
import ghidra.util.bytesearch.PostRule;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public class AlignRule
implements PostRule {
    private int alignOffset;
    private int alignmask;

    public AlignRule() {
    }

    public AlignRule(int alignOffset, int alignmask) {
        this.alignOffset = alignOffset;
        this.alignmask = alignmask;
    }

    @Override
    public boolean apply(Pattern pat, long matchoffset) {
        int off = (int)matchoffset;
        return (off + this.alignOffset & this.alignmask) == 0;
    }

    @Override
    public void restoreXml(XmlPullParser parser) {
        XmlElement el = parser.start(new String[]{"align"});
        this.alignOffset = SpecXmlUtils.decodeInt((String)el.getAttribute("mark"));
        int bits = SpecXmlUtils.decodeInt((String)el.getAttribute("bits"));
        this.alignmask = (1 << bits) - 1;
        parser.end();
    }

    public int getAlignMask() {
        return this.alignmask;
    }
}

