/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.field;

import ghidra.docking.settings.EnumSettingsDefinition;
import ghidra.docking.settings.Settings;

public class AddressRangeEndpointSettingsDefinition
implements EnumSettingsDefinition {
    private static final String ADDRESS_RANGE_ENDPOINT = "Address Range Endpoint";
    private static final String ENDPOINT = "Endpoint";
    public static final String BEGIN = "Begin";
    public static final String END = "End";
    private static final String[] CHOICES = new String[]{"Begin", "End"};
    public static final int BEGIN_CHOICE_INDEX = 0;
    public static final int END_CHOICE_INDEX = 1;
    private static final int DEFAULT = 0;
    public static final AddressRangeEndpointSettingsDefinition DEF = new AddressRangeEndpointSettingsDefinition();

    private AddressRangeEndpointSettingsDefinition() {
    }

    public boolean hasValue(Settings setting) {
        return setting.getValue(ADDRESS_RANGE_ENDPOINT) != null;
    }

    public String getValueString(Settings settings) {
        return CHOICES[this.getChoice(settings)];
    }

    public String getName() {
        return ENDPOINT;
    }

    public String getStorageKey() {
        return ADDRESS_RANGE_ENDPOINT;
    }

    public String getDescription() {
        return "Selects the base address";
    }

    public void clear(Settings settings) {
        settings.clearSetting(ADDRESS_RANGE_ENDPOINT);
    }

    public void copySetting(Settings srcSettings, Settings destSettings) {
        Long l = srcSettings.getLong(ADDRESS_RANGE_ENDPOINT);
        if (l == null) {
            destSettings.clearSetting(ADDRESS_RANGE_ENDPOINT);
        } else {
            destSettings.setLong(ADDRESS_RANGE_ENDPOINT, l.longValue());
        }
    }

    public int getChoice(Settings settings) {
        if (settings == null) {
            return 0;
        }
        Long value = settings.getLong(ADDRESS_RANGE_ENDPOINT);
        if (value == null || value < 0L || value >= (long)CHOICES.length) {
            return 0;
        }
        return value.intValue();
    }

    public void setChoice(Settings settings, int value) {
        if (value < 0) {
            settings.clearSetting(ADDRESS_RANGE_ENDPOINT);
        } else {
            if (value > CHOICES.length) {
                value = CHOICES.length;
            }
            settings.setLong(ADDRESS_RANGE_ENDPOINT, (long)value);
        }
    }

    public String getDisplayChoice(int value, Settings settings) {
        return CHOICES[value];
    }

    public String[] getDisplayChoices(Settings settings) {
        return CHOICES;
    }
}

