/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.callback.ChannelBindingCallback;
import org.wildfly.security.ssl.TLSServerEndPointChannelBinding;

public abstract class SSLConnection {
    SSLConnection() {
    }

    public abstract SSLSession getSession();

    public abstract boolean isClientMode();

    public byte[] getChannelBinding(String bindingType) {
        boolean clientMode = this.isClientMode();
        switch (bindingType) {
            case "tls-server-end-point": {
                X509Certificate serverCert;
                SSLSession session = this.getSession();
                if (session == null) {
                    return null;
                }
                if (clientMode) {
                    Certificate[] peerCertificates;
                    try {
                        peerCertificates = session.getPeerCertificates();
                    }
                    catch (SSLPeerUnverifiedException e) {
                        peerCertificates = null;
                    }
                    serverCert = peerCertificates != null && peerCertificates.length > 0 ? (X509Certificate)peerCertificates[0] : null;
                } else {
                    Certificate[] localCertificates = session.getLocalCertificates();
                    serverCert = localCertificates != null && localCertificates.length > 0 ? (X509Certificate)localCertificates[0] : null;
                }
                try {
                    return TLSServerEndPointChannelBinding.getChannelBindingData(serverCert);
                }
                catch (NoSuchAlgorithmException | CertificateEncodingException e) {
                    return null;
                }
            }
        }
        return null;
    }

    public void handleChannelBindingCallback(ChannelBindingCallback callback) {
        Assert.checkNotNullParam((String)"callback", (Object)callback);
        byte[] bindingData = this.getChannelBinding("tls-unique");
        if (bindingData != null) {
            callback.setBindingType("tls-unique");
            callback.setBindingData(bindingData);
        } else {
            bindingData = this.getChannelBinding("tls-server-end-point");
            if (bindingData != null) {
                callback.setBindingType("tls-server-end-point");
                callback.setBindingData(bindingData);
            }
        }
    }

    public static SSLConnection forEngine(final SSLEngine engine) {
        Assert.checkNotNullParam((String)"engine", (Object)engine);
        return new SSLConnection(){

            @Override
            public SSLSession getSession() {
                return engine.getSession();
            }

            @Override
            public boolean isClientMode() {
                return engine.getUseClientMode();
            }
        };
    }

    public static SSLConnection forSocket(final SSLSocket socket) {
        Assert.checkNotNullParam((String)"socket", (Object)socket);
        return new SSLConnection(){

            @Override
            public SSLSession getSession() {
                return socket.getSession();
            }

            @Override
            public boolean isClientMode() {
                return socket.getUseClientMode();
            }
        };
    }

    public static SSLConnection forSession(final SSLSession session, final boolean clientMode) {
        Assert.checkNotNullParam((String)"session", (Object)session);
        return new SSLConnection(){

            @Override
            public SSLSession getSession() {
                return session;
            }

            @Override
            public boolean isClientMode() {
                return clientMode;
            }
        };
    }
}

