/* 
 *     Copyright (c) 2017-2021, NVIDIA CORPORATION.  All rights reserved.
 *
 * NVIDIA CORPORATION and its licensors retain all intellectual property
 * and proprietary rights in and to this software, related documentation
 * and any modifications thereto.  Any use, reproduction, disclosure or
 * distribution of this software and related documentation without an express
 * license agreement from NVIDIA CORPORATION is strictly prohibited.
 *
 */

/*
 * c++config.h
 *
 * Override any builtins or features where pgc++ differs from g++.
 */

#include_next <bits/c++config.h>

#if !defined(__INT128__)
  #undef _GLIBCXX_USE_INT128
#endif

/* NV HPC only supports 128-bit floats under the name __float128 on x86.
   Rather than a target-specific #if, just use the feature test macro for
   __float128.  NVCC's configuration for NV HPC does not include __float128,
   so disable its use when compiling under NVCC. */
#if !defined(__FLOAT128__) || defined(__NVCC_HOST__)
  #undef _GLIBCXX_USE_FLOAT128
#endif
