/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Arrays;
import oracle.jdbc.driver.BinaryFloatCopyingBinder;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.Datum;

class BinaryFloatBinder
extends Binder {
    float paramVal;
    Binder theBinaryFloatCopyingBinder = null;

    static void init(Binder x) {
        x.type = (short)100;
        x.bytelen = 4;
    }

    BinaryFloatBinder(float x) {
        BinaryFloatBinder.init(this);
        this.paramVal = x;
    }

    @Override
    Binder copyingBinder() {
        if (this.theBinaryFloatCopyingBinder == null) {
            this.theBinaryFloatCopyingBinder = new BinaryFloatCopyingBinder(this.paramVal);
        }
        return this.theBinaryFloatCopyingBinder;
    }

    @Override
    long bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues, long localCheckSum, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths, int bindDataIndex, boolean bindUseDBA, int formOfUse) throws SQLException {
        byte[] b = null;
        int offset = 0;
        float val = this.paramVal;
        int fixedLen = 4;
        long pos = 0L;
        if (bindUseDBA) {
            bindDataOffsets[bindDataIndex] = pos = bindData.getPosition();
            stmt.lastBoundDataOffsets[bindPosition] = pos;
            b = stmt.connection.methodTempLittleByteBuffer;
            offset = 0;
        } else {
            b = bindBytes;
            offset = byteoffset;
        }
        fixedLen = this.getDatumBytes(stmt, val, b, offset);
        if (bindUseDBA) {
            bindData.put(b, 0, fixedLen);
            stmt.lastBoundDataLengths[bindPosition] = fixedLen;
            bindDataLengths[bindDataIndex] = fixedLen;
        }
        bindIndicators[indoffset] = 0;
        bindIndicators[lenoffset] = (short)fixedLen;
        return localCheckSum;
    }

    private int getDatumBytes(OraclePreparedStatement stmt, float val, byte[] b, int offset) throws SQLException {
        int intBits;
        int fixedLen = 4;
        if ((double)val == 0.0) {
            val = 0.0f;
        } else if (val != val) {
            val = Float.NaN;
        }
        int b3 = intBits = Float.floatToIntBits(val);
        int b2 = intBits >>= 8;
        int b1 = intBits >>= 8;
        int b0 = intBits >>= 8;
        if ((b0 & 0x80) == 0) {
            b0 |= 0x80;
        } else {
            b0 ^= 0xFFFFFFFF;
            b1 ^= 0xFFFFFFFF;
            b2 ^= 0xFFFFFFFF;
            b3 ^= 0xFFFFFFFF;
        }
        b[offset + 3] = (byte)b3;
        b[offset + 2] = (byte)b2;
        b[offset + 1] = (byte)b1;
        b[offset] = (byte)b0;
        return fixedLen;
    }

    @Override
    Datum getDatum(OraclePreparedStatement stmt, int bindPosition, int formOfUse, int internalType) throws SQLException {
        byte[] b = stmt.connection.methodTempLittleByteBuffer;
        int len = this.getDatumBytes(stmt, this.paramVal, b, 0);
        return SQLUtil.makeDatum((OracleConnection)stmt.connection, Arrays.copyOf(b, len), internalType, null, 0);
    }
}

