/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.internal.gtk.OS;

public class RTFTransfer
extends ByteArrayTransfer {
    private static RTFTransfer _instance = new RTFTransfer();
    private static final String TEXT_RTF = "text/rtf";
    private static final int TEXT_RTF_ID = RTFTransfer.registerType("text/rtf");
    private static final String TEXT_RTF2 = "TEXT/RTF";
    private static final int TEXT_RTF2_ID = RTFTransfer.registerType("TEXT/RTF");
    private static final String APPLICATION_RTF = "application/rtf";
    private static final int APPLICATION_RTF_ID = RTFTransfer.registerType("application/rtf");

    private RTFTransfer() {
    }

    public static RTFTransfer getInstance() {
        return _instance;
    }

    @Override
    public void javaToNative(Object object, TransferData transferData) {
        String string;
        byte[] buffer;
        long pValue;
        if (GTK.GTK4) {
            this.javaToNativeGTK4(object, transferData);
            return;
        }
        transferData.result = 0;
        if (!this.checkRTF(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        if ((pValue = OS.g_malloc((buffer = Converter.wcsToMbcs(string = (String)object, true)).length)) == 0L) {
            return;
        }
        C.memmove(pValue, buffer, (long)buffer.length);
        transferData.length = buffer.length - 1;
        transferData.format = 8;
        transferData.pValue = pValue;
        transferData.result = 1;
    }

    private void javaToNativeGTK4(Object object, TransferData transferData) {
        if (!this.checkRTF(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        super.javaToNative(Converter.wcsToMbcs((String)object, false), transferData);
    }

    @Override
    public Object nativeToJava(TransferData transferData) {
        if (GTK.GTK4) {
            return this.nativeToJavaGTK4(transferData);
        }
        if (!this.isSupportedType(transferData) || transferData.pValue == 0L) {
            return null;
        }
        int size = transferData.format * transferData.length / 8;
        if (size == 0) {
            return null;
        }
        byte[] buffer = new byte[size];
        C.memmove(buffer, transferData.pValue, (long)size);
        char[] chars = Converter.mbcsToWcs(buffer);
        String string = new String(chars);
        int end = string.indexOf(0);
        return end == -1 ? string : string.substring(0, end);
    }

    private Object nativeToJavaGTK4(TransferData transferData) {
        Object buffer = super.nativeToJava(transferData);
        if (buffer instanceof byte[]) {
            byte[] bytes = (byte[])buffer;
            return new String(Converter.mbcsToWcs(bytes));
        }
        return null;
    }

    @Override
    protected int[] getTypeIds() {
        return new int[]{TEXT_RTF_ID, TEXT_RTF2_ID, APPLICATION_RTF_ID};
    }

    @Override
    protected String[] getTypeNames() {
        return new String[]{TEXT_RTF, TEXT_RTF2, APPLICATION_RTF};
    }

    boolean checkRTF(Object object) {
        return object instanceof String && !((String)object).isEmpty();
    }

    @Override
    protected boolean validate(Object object) {
        return this.checkRTF(object);
    }
}

