/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cache.spi.access.CollectionDataAccess;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.spi.PersisterClassResolver;
import org.hibernate.persister.spi.PersisterFactory;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public final class PersisterFactoryImpl
implements PersisterFactory,
ServiceRegistryAwareService {
    public static final Class<?>[] ENTITY_PERSISTER_CONSTRUCTOR_ARGS = new Class[]{PersistentClass.class, EntityDataAccess.class, NaturalIdDataAccess.class, RuntimeModelCreationContext.class};
    public static final Class<?>[] COLLECTION_PERSISTER_CONSTRUCTOR_ARGS = new Class[]{Collection.class, CollectionDataAccess.class, RuntimeModelCreationContext.class};
    private PersisterClassResolver persisterClassResolver;

    @Override
    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.persisterClassResolver = serviceRegistry.getService(PersisterClassResolver.class);
    }

    @Override
    public EntityPersister createEntityPersister(PersistentClass entityBinding, EntityDataAccess entityCacheAccessStrategy, NaturalIdDataAccess naturalIdCacheAccessStrategy, RuntimeModelCreationContext creationContext) {
        Class<? extends EntityPersister> persisterClass = this.persisterClassResolver.getEntityPersisterClass(entityBinding);
        Constructor<? extends EntityPersister> constructor = this.resolveEntityPersisterConstructor(persisterClass);
        try {
            return constructor.newInstance(entityBinding, entityCacheAccessStrategy, naturalIdCacheAccessStrategy, creationContext);
        }
        catch (MappingException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof HibernateException) {
                HibernateException hibernateException = (HibernateException)((Object)target);
                throw hibernateException;
            }
            throw new MappingException(String.format(Locale.ROOT, "Could not instantiate persister %s (%s)", persisterClass.getName(), entityBinding.getEntityName()), target);
        }
        catch (Exception e) {
            throw new MappingException(String.format(Locale.ROOT, "Could not instantiate persister %s (%s)", persisterClass.getName(), entityBinding.getEntityName()), e);
        }
    }

    private Constructor<? extends EntityPersister> resolveEntityPersisterConstructor(Class<? extends EntityPersister> persisterClass) {
        try {
            return persisterClass.getConstructor(ENTITY_PERSISTER_CONSTRUCTOR_ARGS);
        }
        catch (NoSuchMethodException noConstructorException) {
            throw new MappingException("Could not find appropriate constructor for " + persisterClass.getName(), noConstructorException);
        }
    }

    @Override
    public CollectionPersister createCollectionPersister(Collection collectionBinding, @Nullable CollectionDataAccess cacheAccessStrategy, RuntimeModelCreationContext creationContext) {
        Class<? extends CollectionPersister> persisterClass = this.persisterClassResolver.getCollectionPersisterClass(collectionBinding);
        Constructor<? extends CollectionPersister> constructor = this.resolveCollectionPersisterConstructor(persisterClass);
        try {
            return constructor.newInstance(collectionBinding, cacheAccessStrategy, creationContext);
        }
        catch (MappingException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof HibernateException) {
                HibernateException hibernateException = (HibernateException)((Object)target);
                throw hibernateException;
            }
            throw new MappingException(String.format("Could not instantiate collection persister implementor `%s` for collection-role `%s`", persisterClass.getName(), collectionBinding.getRole()), target);
        }
        catch (Exception e) {
            throw new MappingException("Could not instantiate collection persister " + persisterClass.getName(), e);
        }
    }

    private Constructor<? extends CollectionPersister> resolveCollectionPersisterConstructor(Class<? extends CollectionPersister> persisterClass) {
        try {
            return persisterClass.getConstructor(COLLECTION_PERSISTER_CONSTRUCTOR_ARGS);
        }
        catch (NoSuchMethodException noConstructorException) {
            throw new MappingException("Could not find appropriate constructor for " + persisterClass.getName(), noConstructorException);
        }
    }
}

