/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.http.link;

import java.nio.charset.Charset;
import java.util.Objects;
import java.util.Optional;

public final class LinkAttribute {
    private final String name;
    private final String value;
    private final String languageTag;

    protected LinkAttribute(String name) {
        this(name, name, null);
    }

    protected LinkAttribute(String name, String value) {
        this(name, value, null);
    }

    protected LinkAttribute(String name, String value, String languageTag) {
        this.name = name;
        this.value = value;
        this.languageTag = languageTag;
    }

    public Optional<String> languageTag() {
        return Optional.ofNullable(this.languageTag);
    }

    public String name() {
        return this.name;
    }

    public String value() {
        return this.value;
    }

    public String toString() {
        if (this.value == null) {
            return this.name;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.name);
        builder.append('=');
        if (this.languageTag != null) {
            builder.append(Charset.defaultCharset().name());
            builder.append('\'');
            builder.append(this.languageTag);
            builder.append('\'');
        }
        builder.append(this.value);
        return builder.toString();
    }

    public int hashCode() {
        return Objects.hash(this.languageTag, this.name, this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LinkAttribute other = (LinkAttribute)obj;
        return Objects.equals(this.languageTag, other.languageTag) && Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value);
    }
}

