/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.lang.reflect.UndeclaredThrowableException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;
import org.wildfly.security.sasl.util.AbstractDelegatingSaslServerFactory;
import org.wildfly.security.sasl.util.PrivilegedSaslServer;

public final class PrivilegedSaslServerFactory
extends AbstractDelegatingSaslServerFactory {
    private final AccessControlContext context;

    public PrivilegedSaslServerFactory(SaslServerFactory delegate) {
        this(delegate, AccessController.getContext());
    }

    PrivilegedSaslServerFactory(SaslServerFactory delegate, AccessControlContext context) {
        super(delegate);
        this.context = context;
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        SaslServer saslServer;
        try {
            saslServer = AccessController.doPrivileged(() -> this.delegate.createSaslServer(mechanism, protocol, serverName, props, cbh));
        }
        catch (PrivilegedActionException pae) {
            try {
                throw pae.getCause();
            }
            catch (Error | RuntimeException | SaslException e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw new UndeclaredThrowableException(throwable);
            }
        }
        return saslServer == null ? null : new PrivilegedSaslServer(saslServer, this.context);
    }
}

