/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.setting;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Dictionary;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.bootstrap.BootstrapInfo;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.SecureSetting;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.settings.SecureString;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.http.HttpTransportSettings;
import org.opensearch.notifications.core.utils.HelpersKt;
import org.opensearch.notifications.core.utils.OpenForTesting;
import org.opensearch.notifications.spi.model.SecureDestinationSettings;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b0\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u007f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030`0\"J\u0014\u0010\u0080\u0001\u001a\u00030\u0081\u00012\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001H\u0002J\u0014\u0010\u0084\u0001\u001a\u00030\u0081\u00012\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001H\u0002J\u0012\u0010\u0085\u0001\u001a\u00030\u0081\u00012\b\u0010\u0082\u0001\u001a\u00030\u0083\u0001J\u001d\u0010\u0086\u0001\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020(0'2\b\u0010\u0087\u0001\u001a\u00030\u0088\u0001J\u001e\u0010\u0089\u0001\u001a\u0004\u0018\u00010(2\b\u0010\u0087\u0001\u001a\u00030\u0088\u00012\u0007\u0010\u008a\u0001\u001a\u00020\u0005H\u0002J<\u0010\u008b\u0001\u001a\u0005\u0018\u0001H\u008c\u0001\"\u0005\b\u0000\u0010\u008c\u00012\b\u0010\u0087\u0001\u001a\u00030\u0088\u00012\u0007\u0010\u008a\u0001\u001a\u00020\u00052\u000e\u0010\u008d\u0001\u001a\t\u0012\u0005\u0012\u0003H\u008c\u00010zH\u0002\u00a2\u0006\u0003\u0010\u008e\u0001JD\u0010\u008f\u0001\u001a\u000b\u0012\u0005\u0012\u0003H\u008c\u0001\u0018\u00010`\"\u0005\b\u0000\u0010\u008c\u00012\u0007\u0010\u0090\u0001\u001a\u00020\u00052\u000e\u0010\u0091\u0001\u001a\t\u0012\u0005\u0012\u0003H\u008c\u00010z2\u0007\u0010\u0092\u0001\u001a\u00020\u00052\u0007\u0010\u0093\u0001\u001a\u00020\u0005H\u0002J\n\u0010\u0094\u0001\u001a\u00030\u0081\u0001H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0019X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0019X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0019X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0019X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0019X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001a\u00103\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00100\"\u0004\b5\u00102R\u001a\u00106\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00100\"\u0004\b8\u00102R\u001a\u00109\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u00100\"\u0004\b;\u00102R\u001a\u0010<\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u00100\"\u0004\b>\u00102R\u001a\u0010?\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b@\u00100\"\u0004\bA\u00102R\u001a\u0010B\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u00100\"\u0004\bD\u00102R\u001a\u0010E\u001a\u00020%X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR \u0010J\u001a\b\u0012\u0004\u0012\u00020\u00050\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010+\"\u0004\bL\u0010-R\u001a\u0010M\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010O\"\u0004\bP\u0010QR&\u0010R\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020(0'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010T\"\u0004\bU\u0010VR\u000e\u0010W\u001a\u00020\u0019X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010X\u001a\u00020Y8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\\\u0010]\u001a\u0004\bZ\u0010[R\u001a\u0010^\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010_\u001a\b\u0012\u0004\u0012\u00020\u00190`\u00a2\u0006\b\n\u0000\u001a\u0004\ba\u0010bR\u0017\u0010c\u001a\b\u0012\u0004\u0012\u00020\u00190`\u00a2\u0006\b\n\u0000\u001a\u0004\bd\u0010bR\u0017\u0010e\u001a\b\u0012\u0004\u0012\u00020\u00190`\u00a2\u0006\b\n\u0000\u001a\u0004\bf\u0010bR\u0017\u0010g\u001a\b\u0012\u0004\u0012\u00020\u00190`\u00a2\u0006\b\n\u0000\u001a\u0004\bh\u0010bR\u0017\u0010i\u001a\b\u0012\u0004\u0012\u00020\u00190`\u00a2\u0006\b\n\u0000\u001a\u0004\bj\u0010bR\u0017\u0010k\u001a\b\u0012\u0004\u0012\u00020\u00190`\u00a2\u0006\b\n\u0000\u001a\u0004\bl\u0010bR\u0017\u0010m\u001a\b\u0012\u0004\u0012\u00020\u00190`\u00a2\u0006\b\n\u0000\u001a\u0004\bn\u0010bR\u001d\u0010o\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\"0`\u00a2\u0006\b\n\u0000\u001a\u0004\bp\u0010bR\u0017\u0010q\u001a\b\u0012\u0004\u0012\u00020%0`\u00a2\u0006\b\n\u0000\u001a\u0004\br\u0010bR\u001d\u0010s\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\"0`\u00a2\u0006\b\n\u0000\u001a\u0004\bt\u0010bR\u001d\u0010u\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\"0`\u00a2\u0006\b\n\u0000\u001a\u0004\bv\u0010bR\u001d\u0010w\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\"0`\u00a2\u0006\b\n\u0000\u001a\u0004\bx\u0010bR\u0014\u0010y\u001a\b\u0012\u0004\u0012\u00020{0zX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010|\u001a\b\u0012\u0004\u0012\u00020{0zX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010}\u001a\b\u0012\u0004\u0012\u00020{0zX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010~\u001a\b\u0012\u0004\u0012\u00020{0zX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0095\u0001"}, d2={"Lorg/opensearch/notifications/core/setting/PluginSettings;", "", "<init>", "()V", "KEY_PREFIX", "", "EMAIL_KEY_PREFIX", "LEGACY_EMAIL_DESTINATION_SETTING_PREFIX", "EMAIL_DESTINATION_SETTING_PREFIX", "HTTP_CONNECTION_KEY_PREFIX", "EMAIL_SIZE_LIMIT_KEY", "EMAIL_MINIMUM_HEADER_LENGTH_KEY", "MAX_CONNECTIONS_KEY", "MAX_CONNECTIONS_PER_ROUTE_KEY", "CONNECTION_TIMEOUT_MILLISECONDS_KEY", "SOCKET_TIMEOUT_MILLISECONDS_KEY", "MAX_HTTP_RESPONSE_SIZE_KEY", "LEGACY_ALERTING_HOST_DENY_LIST_KEY", "ALERTING_HOST_DENY_LIST_KEY", "HOST_DENY_LIST_KEY", "ALLOWED_CONFIG_TYPE_KEY", "TOOLTIP_SUPPORT_KEY", "CLUSTER_NAME", "DEFAULT_CLUSTER_NAME", "DEFAULT_EMAIL_SIZE_LIMIT", "", "MINIMUM_EMAIL_SIZE_LIMIT", "DEFAULT_MAX_CONNECTIONS", "DEFAULT_MAX_CONNECTIONS_PER_ROUTE", "DEFAULT_CONNECTION_TIMEOUT_MILLISECONDS", "DEFAULT_SOCKET_TIMEOUT_MILLISECONDS", "DEFAULT_MAX_HTTP_RESPONSE_SIZE", "DEFAULT_MINIMUM_EMAIL_HEADER_LENGTH", "DEFAULT_ALLOWED_CONFIG_TYPES", "", "DEFAULT_HOST_DENY_LIST", "DEFAULT_TOOLTIP_SUPPORT", "", "DEFAULT_DESTINATION_SETTINGS", "", "Lorg/opensearch/notifications/spi/model/SecureDestinationSettings;", "allowedConfigTypes", "getAllowedConfigTypes", "()Ljava/util/List;", "setAllowedConfigTypes", "(Ljava/util/List;)V", "emailSizeLimit", "getEmailSizeLimit", "()I", "setEmailSizeLimit", "(I)V", "emailMinimumHeaderLength", "getEmailMinimumHeaderLength", "setEmailMinimumHeaderLength", "maxConnections", "getMaxConnections", "setMaxConnections", "maxConnectionsPerRoute", "getMaxConnectionsPerRoute", "setMaxConnectionsPerRoute", "connectionTimeout", "getConnectionTimeout", "setConnectionTimeout", "socketTimeout", "getSocketTimeout", "setSocketTimeout", "maxHttpResponseSize", "getMaxHttpResponseSize", "setMaxHttpResponseSize", "tooltipSupport", "getTooltipSupport", "()Z", "setTooltipSupport", "(Z)V", "hostDenyList", "getHostDenyList", "setHostDenyList", "clusterName", "getClusterName", "()Ljava/lang/String;", "setClusterName", "(Ljava/lang/String;)V", "destinationSettings", "getDestinationSettings", "()Ljava/util/Map;", "setDestinationSettings", "(Ljava/util/Map;)V", "DECIMAL_RADIX", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "defaultSettings", "EMAIL_SIZE_LIMIT", "Lorg/opensearch/common/settings/Setting;", "getEMAIL_SIZE_LIMIT", "()Lorg/opensearch/common/settings/Setting;", "EMAIL_MINIMUM_HEADER_LENGTH", "getEMAIL_MINIMUM_HEADER_LENGTH", "MAX_CONNECTIONS", "getMAX_CONNECTIONS", "MAX_CONNECTIONS_PER_ROUTE", "getMAX_CONNECTIONS_PER_ROUTE", "CONNECTION_TIMEOUT_MILLISECONDS", "getCONNECTION_TIMEOUT_MILLISECONDS", "SOCKET_TIMEOUT_MILLISECONDS", "getSOCKET_TIMEOUT_MILLISECONDS", "MAX_HTTP_RESPONSE_SIZE", "getMAX_HTTP_RESPONSE_SIZE", "ALLOWED_CONFIG_TYPES", "getALLOWED_CONFIG_TYPES", "TOOLTIP_SUPPORT", "getTOOLTIP_SUPPORT", "LEGACY_ALERTING_HOST_DENY_LIST", "getLEGACY_ALERTING_HOST_DENY_LIST", "ALERTING_HOST_DENY_LIST", "getALERTING_HOST_DENY_LIST", "HOST_DENY_LIST", "getHOST_DENY_LIST", "LEGACY_EMAIL_USERNAME", "Lorg/opensearch/common/settings/Setting$AffixSetting;", "Lorg/opensearch/core/common/settings/SecureString;", "LEGACY_EMAIL_PASSWORD", "EMAIL_USERNAME", "EMAIL_PASSWORD", "getAllSettings", "updateSettingValuesFromLocal", "", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "updateSettingValuesFromCluster", "addSettingsUpdateConsumer", "loadDestinationSettings", "settings", "Lorg/opensearch/common/settings/Settings;", "getSecureDestinationSettings", "emailAccountName", "getEmailSettingValue", "T", "emailSetting", "(Lorg/opensearch/common/settings/Settings;Ljava/lang/String;Lorg/opensearch/common/settings/Setting$AffixSetting;)Ljava/lang/Object;", "fallback", "key", "affixSetting", "regex", "replacement", "reset", "opensearch-notifications-core"})
public final class PluginSettings {
    @NotNull
    public static final PluginSettings INSTANCE;
    @NotNull
    private static final String KEY_PREFIX = "opensearch.notifications.core";
    @NotNull
    private static final String EMAIL_KEY_PREFIX = "opensearch.notifications.core.email";
    @NotNull
    private static final String LEGACY_EMAIL_DESTINATION_SETTING_PREFIX = "plugins.alerting.destination.email.";
    @NotNull
    private static final String EMAIL_DESTINATION_SETTING_PREFIX = "opensearch.notifications.core.email.";
    @NotNull
    private static final String HTTP_CONNECTION_KEY_PREFIX = "opensearch.notifications.core.http";
    @NotNull
    private static final String EMAIL_SIZE_LIMIT_KEY = "opensearch.notifications.core.email.size_limit";
    @NotNull
    private static final String EMAIL_MINIMUM_HEADER_LENGTH_KEY = "opensearch.notifications.core.email.minimum_header_length";
    @NotNull
    private static final String MAX_CONNECTIONS_KEY = "opensearch.notifications.core.http.max_connections";
    @NotNull
    private static final String MAX_CONNECTIONS_PER_ROUTE_KEY = "opensearch.notifications.core.http.max_connection_per_route";
    @NotNull
    private static final String CONNECTION_TIMEOUT_MILLISECONDS_KEY = "opensearch.notifications.core.http.connection_timeout";
    @NotNull
    private static final String SOCKET_TIMEOUT_MILLISECONDS_KEY = "opensearch.notifications.core.http.socket_timeout";
    @NotNull
    private static final String MAX_HTTP_RESPONSE_SIZE_KEY = "opensearch.notifications.core.max_http_response_size";
    @NotNull
    private static final String LEGACY_ALERTING_HOST_DENY_LIST_KEY = "opendistro.destination.host.deny_list";
    @NotNull
    private static final String ALERTING_HOST_DENY_LIST_KEY = "plugins.destination.host.deny_list";
    @NotNull
    private static final String HOST_DENY_LIST_KEY = "opensearch.notifications.core.http.host_deny_list";
    @NotNull
    private static final String ALLOWED_CONFIG_TYPE_KEY = "opensearch.notifications.core.allowed_config_types";
    @NotNull
    private static final String TOOLTIP_SUPPORT_KEY = "opensearch.notifications.core.tooltip_support";
    @NotNull
    private static final String CLUSTER_NAME = "cluster.name";
    @NotNull
    private static final String DEFAULT_CLUSTER_NAME = "OpenSearch:DefaultClusterName";
    private static final int DEFAULT_EMAIL_SIZE_LIMIT = 10000000;
    private static final int MINIMUM_EMAIL_SIZE_LIMIT = 10000;
    private static final int DEFAULT_MAX_CONNECTIONS = 60;
    private static final int DEFAULT_MAX_CONNECTIONS_PER_ROUTE = 20;
    private static final int DEFAULT_CONNECTION_TIMEOUT_MILLISECONDS = 5000;
    private static final int DEFAULT_SOCKET_TIMEOUT_MILLISECONDS = 50000;
    private static final int DEFAULT_MAX_HTTP_RESPONSE_SIZE;
    private static final int DEFAULT_MINIMUM_EMAIL_HEADER_LENGTH = 160;
    @NotNull
    private static final List<String> DEFAULT_ALLOWED_CONFIG_TYPES;
    @NotNull
    private static final List<String> DEFAULT_HOST_DENY_LIST;
    private static final boolean DEFAULT_TOOLTIP_SUPPORT = true;
    @NotNull
    private static final Map<String, SecureDestinationSettings> DEFAULT_DESTINATION_SETTINGS;
    @NotNull
    private static volatile List<String> allowedConfigTypes;
    private static volatile int emailSizeLimit;
    private static volatile int emailMinimumHeaderLength;
    private static volatile int maxConnections;
    private static volatile int maxConnectionsPerRoute;
    private static volatile int connectionTimeout;
    private static volatile int socketTimeout;
    private static volatile int maxHttpResponseSize;
    private static volatile boolean tooltipSupport;
    @NotNull
    private static volatile List<String> hostDenyList;
    @NotNull
    private static volatile String clusterName;
    @NotNull
    private static volatile Map<String, SecureDestinationSettings> destinationSettings;
    private static final int DECIMAL_RADIX = 10;
    @NotNull
    private static final Lazy log$delegate;
    @NotNull
    private static final Map<String, String> defaultSettings;
    @NotNull
    private static final Setting<Integer> EMAIL_SIZE_LIMIT;
    @NotNull
    private static final Setting<Integer> EMAIL_MINIMUM_HEADER_LENGTH;
    @NotNull
    private static final Setting<Integer> MAX_CONNECTIONS;
    @NotNull
    private static final Setting<Integer> MAX_CONNECTIONS_PER_ROUTE;
    @NotNull
    private static final Setting<Integer> CONNECTION_TIMEOUT_MILLISECONDS;
    @NotNull
    private static final Setting<Integer> SOCKET_TIMEOUT_MILLISECONDS;
    @NotNull
    private static final Setting<Integer> MAX_HTTP_RESPONSE_SIZE;
    @NotNull
    private static final Setting<List<String>> ALLOWED_CONFIG_TYPES;
    @NotNull
    private static final Setting<Boolean> TOOLTIP_SUPPORT;
    @NotNull
    private static final Setting<List<String>> LEGACY_ALERTING_HOST_DENY_LIST;
    @NotNull
    private static final Setting<List<String>> ALERTING_HOST_DENY_LIST;
    @NotNull
    private static final Setting<List<String>> HOST_DENY_LIST;
    @NotNull
    private static final Setting.AffixSetting<SecureString> LEGACY_EMAIL_USERNAME;
    @NotNull
    private static final Setting.AffixSetting<SecureString> LEGACY_EMAIL_PASSWORD;
    @NotNull
    private static final Setting.AffixSetting<SecureString> EMAIL_USERNAME;
    @NotNull
    private static final Setting.AffixSetting<SecureString> EMAIL_PASSWORD;

    private PluginSettings() {
    }

    @NotNull
    public final List<String> getAllowedConfigTypes() {
        return allowedConfigTypes;
    }

    public final void setAllowedConfigTypes(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        allowedConfigTypes = list;
    }

    public final int getEmailSizeLimit() {
        return emailSizeLimit;
    }

    public final void setEmailSizeLimit(int n) {
        emailSizeLimit = n;
    }

    public final int getEmailMinimumHeaderLength() {
        return emailMinimumHeaderLength;
    }

    public final void setEmailMinimumHeaderLength(int n) {
        emailMinimumHeaderLength = n;
    }

    public final int getMaxConnections() {
        return maxConnections;
    }

    public final void setMaxConnections(int n) {
        maxConnections = n;
    }

    public final int getMaxConnectionsPerRoute() {
        return maxConnectionsPerRoute;
    }

    public final void setMaxConnectionsPerRoute(int n) {
        maxConnectionsPerRoute = n;
    }

    public final int getConnectionTimeout() {
        return connectionTimeout;
    }

    public final void setConnectionTimeout(int n) {
        connectionTimeout = n;
    }

    public final int getSocketTimeout() {
        return socketTimeout;
    }

    public final void setSocketTimeout(int n) {
        socketTimeout = n;
    }

    public final int getMaxHttpResponseSize() {
        return maxHttpResponseSize;
    }

    public final void setMaxHttpResponseSize(int n) {
        maxHttpResponseSize = n;
    }

    public final boolean getTooltipSupport() {
        return tooltipSupport;
    }

    public final void setTooltipSupport(boolean bl) {
        tooltipSupport = bl;
    }

    @NotNull
    public final List<String> getHostDenyList() {
        return hostDenyList;
    }

    public final void setHostDenyList(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        hostDenyList = list;
    }

    @NotNull
    public final String getClusterName() {
        return clusterName;
    }

    public final void setClusterName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        clusterName = string;
    }

    @NotNull
    public final Map<String, SecureDestinationSettings> getDestinationSettings() {
        return destinationSettings;
    }

    public final void setDestinationSettings(@NotNull Map<String, SecureDestinationSettings> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        destinationSettings = map;
    }

    private final Logger getLog() {
        Lazy lazy = log$delegate;
        return (Logger)lazy.getValue();
    }

    @NotNull
    public final Setting<Integer> getEMAIL_SIZE_LIMIT() {
        return EMAIL_SIZE_LIMIT;
    }

    @NotNull
    public final Setting<Integer> getEMAIL_MINIMUM_HEADER_LENGTH() {
        return EMAIL_MINIMUM_HEADER_LENGTH;
    }

    @NotNull
    public final Setting<Integer> getMAX_CONNECTIONS() {
        return MAX_CONNECTIONS;
    }

    @NotNull
    public final Setting<Integer> getMAX_CONNECTIONS_PER_ROUTE() {
        return MAX_CONNECTIONS_PER_ROUTE;
    }

    @NotNull
    public final Setting<Integer> getCONNECTION_TIMEOUT_MILLISECONDS() {
        return CONNECTION_TIMEOUT_MILLISECONDS;
    }

    @NotNull
    public final Setting<Integer> getSOCKET_TIMEOUT_MILLISECONDS() {
        return SOCKET_TIMEOUT_MILLISECONDS;
    }

    @NotNull
    public final Setting<Integer> getMAX_HTTP_RESPONSE_SIZE() {
        return MAX_HTTP_RESPONSE_SIZE;
    }

    @NotNull
    public final Setting<List<String>> getALLOWED_CONFIG_TYPES() {
        return ALLOWED_CONFIG_TYPES;
    }

    @NotNull
    public final Setting<Boolean> getTOOLTIP_SUPPORT() {
        return TOOLTIP_SUPPORT;
    }

    @NotNull
    public final Setting<List<String>> getLEGACY_ALERTING_HOST_DENY_LIST() {
        return LEGACY_ALERTING_HOST_DENY_LIST;
    }

    @NotNull
    public final Setting<List<String>> getALERTING_HOST_DENY_LIST() {
        return ALERTING_HOST_DENY_LIST;
    }

    @NotNull
    public final Setting<List<String>> getHOST_DENY_LIST() {
        return HOST_DENY_LIST;
    }

    @NotNull
    public final List<Setting<?>> getAllSettings() {
        Object[] objectArray = new Setting[]{EMAIL_SIZE_LIMIT, EMAIL_MINIMUM_HEADER_LENGTH, MAX_CONNECTIONS, MAX_CONNECTIONS_PER_ROUTE, CONNECTION_TIMEOUT_MILLISECONDS, SOCKET_TIMEOUT_MILLISECONDS, MAX_HTTP_RESPONSE_SIZE, ALLOWED_CONFIG_TYPES, TOOLTIP_SUPPORT, HOST_DENY_LIST, EMAIL_USERNAME, EMAIL_PASSWORD};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final void updateSettingValuesFromLocal(ClusterService clusterService) {
        Object object = ALLOWED_CONFIG_TYPES.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        allowedConfigTypes = (List)object;
        Object object2 = EMAIL_SIZE_LIMIT.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        emailSizeLimit = ((Number)object2).intValue();
        Object object3 = EMAIL_MINIMUM_HEADER_LENGTH.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        emailMinimumHeaderLength = ((Number)object3).intValue();
        Object object4 = MAX_CONNECTIONS.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
        maxConnections = ((Number)object4).intValue();
        Object object5 = MAX_CONNECTIONS_PER_ROUTE.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"get(...)");
        maxConnectionsPerRoute = ((Number)object5).intValue();
        Object object6 = CONNECTION_TIMEOUT_MILLISECONDS.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"get(...)");
        connectionTimeout = ((Number)object6).intValue();
        Object object7 = SOCKET_TIMEOUT_MILLISECONDS.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object7, (String)"get(...)");
        socketTimeout = ((Number)object7).intValue();
        Object object8 = MAX_HTTP_RESPONSE_SIZE.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object8, (String)"get(...)");
        maxHttpResponseSize = ((Number)object8).intValue();
        Object object9 = TOOLTIP_SUPPORT.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object9, (String)"get(...)");
        tooltipSupport = (Boolean)object9;
        Object object10 = HOST_DENY_LIST.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object10, (String)"get(...)");
        hostDenyList = (List)object10;
        Settings settings = clusterService.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)settings, (String)"getSettings(...)");
        destinationSettings = this.loadDestinationSettings(settings);
        String string = clusterService.getClusterName().value();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value(...)");
        clusterName = string;
    }

    private final void updateSettingValuesFromCluster(ClusterService clusterService) {
        ClusterName clusterClusterName;
        List clusterHostDenyList;
        Boolean clusterTooltipSupport;
        List clusterAllowedConfigTypes;
        Integer clusterMaxHttpResponseSize;
        Integer clusterSocketTimeout;
        Integer clusterConnectionTimeout;
        Integer clusterMaxConnectionsPerRoute;
        Integer clusterMaxConnections;
        Integer clusterEmailMinimumHeaderLength;
        Integer clusterEmailSizeLimit = (Integer)clusterService.getClusterSettings().get(EMAIL_SIZE_LIMIT);
        if (clusterEmailSizeLimit != null) {
            this.getLog().debug("notifications-core:opensearch.notifications.core.email.size_limit -autoUpdatedTo-> " + clusterEmailSizeLimit);
            emailSizeLimit = clusterEmailSizeLimit;
        }
        if ((clusterEmailMinimumHeaderLength = (Integer)clusterService.getClusterSettings().get(EMAIL_MINIMUM_HEADER_LENGTH)) != null) {
            this.getLog().debug("notifications-core:opensearch.notifications.core.email.minimum_header_length -autoUpdatedTo-> " + clusterEmailMinimumHeaderLength);
            emailMinimumHeaderLength = clusterEmailMinimumHeaderLength;
        }
        if ((clusterMaxConnections = (Integer)clusterService.getClusterSettings().get(MAX_CONNECTIONS)) != null) {
            this.getLog().debug("notifications-core:opensearch.notifications.core.http.max_connections -autoUpdatedTo-> " + clusterMaxConnections);
            maxConnections = clusterMaxConnections;
        }
        if ((clusterMaxConnectionsPerRoute = (Integer)clusterService.getClusterSettings().get(MAX_CONNECTIONS_PER_ROUTE)) != null) {
            this.getLog().debug("notifications-core:opensearch.notifications.core.http.max_connection_per_route -autoUpdatedTo-> " + clusterMaxConnectionsPerRoute);
            maxConnectionsPerRoute = clusterMaxConnectionsPerRoute;
        }
        if ((clusterConnectionTimeout = (Integer)clusterService.getClusterSettings().get(CONNECTION_TIMEOUT_MILLISECONDS)) != null) {
            this.getLog().debug("notifications-core:opensearch.notifications.core.http.connection_timeout -autoUpdatedTo-> " + clusterConnectionTimeout);
            connectionTimeout = clusterConnectionTimeout;
        }
        if ((clusterSocketTimeout = (Integer)clusterService.getClusterSettings().get(SOCKET_TIMEOUT_MILLISECONDS)) != null) {
            this.getLog().debug("notifications-core:opensearch.notifications.core.http.socket_timeout -autoUpdatedTo-> " + clusterSocketTimeout);
            socketTimeout = clusterSocketTimeout;
        }
        if ((clusterMaxHttpResponseSize = (Integer)clusterService.getClusterSettings().get(MAX_HTTP_RESPONSE_SIZE)) != null) {
            this.getLog().debug("notifications-core:opensearch.notifications.core.max_http_response_size -autoUpdatedTo-> " + clusterMaxHttpResponseSize);
            maxHttpResponseSize = clusterMaxHttpResponseSize;
        }
        if ((clusterAllowedConfigTypes = (List)clusterService.getClusterSettings().get(ALLOWED_CONFIG_TYPES)) != null) {
            this.getLog().debug("notifications-core:opensearch.notifications.core.allowed_config_types -autoUpdatedTo-> " + clusterAllowedConfigTypes);
            allowedConfigTypes = clusterAllowedConfigTypes;
        }
        if ((clusterTooltipSupport = (Boolean)clusterService.getClusterSettings().get(TOOLTIP_SUPPORT)) != null) {
            this.getLog().debug("notifications-core:opensearch.notifications.core.tooltip_support -autoUpdatedTo-> " + clusterTooltipSupport);
            tooltipSupport = clusterTooltipSupport;
        }
        if ((clusterHostDenyList = (List)clusterService.getClusterSettings().get(HOST_DENY_LIST)) != null) {
            this.getLog().debug("notifications-core:opensearch.notifications.core.http.host_deny_list -autoUpdatedTo-> " + clusterHostDenyList);
            hostDenyList = clusterHostDenyList;
        }
        if ((clusterClusterName = clusterService.getClusterName()) != null) {
            this.getLog().debug("notifications-core:" + ClusterName.CLUSTER_NAME_SETTING + " -autoUpdatedTo-> " + clusterClusterName);
            String string = clusterClusterName.value();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"value(...)");
            clusterName = string;
        }
    }

    public final void addSettingsUpdateConsumer(@NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        this.updateSettingValuesFromLocal(clusterService);
        this.updateSettingValuesFromCluster(clusterService);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(ALLOWED_CONFIG_TYPES, PluginSettings::addSettingsUpdateConsumer$lambda$0);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(EMAIL_SIZE_LIMIT, PluginSettings::addSettingsUpdateConsumer$lambda$1);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(EMAIL_MINIMUM_HEADER_LENGTH, PluginSettings::addSettingsUpdateConsumer$lambda$2);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_CONNECTIONS, PluginSettings::addSettingsUpdateConsumer$lambda$3);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_CONNECTIONS_PER_ROUTE, PluginSettings::addSettingsUpdateConsumer$lambda$4);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(CONNECTION_TIMEOUT_MILLISECONDS, PluginSettings::addSettingsUpdateConsumer$lambda$5);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SOCKET_TIMEOUT_MILLISECONDS, PluginSettings::addSettingsUpdateConsumer$lambda$6);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_HTTP_RESPONSE_SIZE, PluginSettings::addSettingsUpdateConsumer$lambda$7);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(TOOLTIP_SUPPORT, PluginSettings::addSettingsUpdateConsumer$lambda$8);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(HOST_DENY_LIST, PluginSettings::addSettingsUpdateConsumer$lambda$9);
    }

    @NotNull
    public final Map<String, SecureDestinationSettings> loadDestinationSettings(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Set emailAccountNames = settings.getGroups(EMAIL_DESTINATION_SETTING_PREFIX, true).keySet();
        Set legacyEmailAccountNames = settings.getGroups(LEGACY_EMAIL_DESTINATION_SETTING_PREFIX, true).keySet();
        emailAccountNames = CollectionsKt.union((Iterable)emailAccountNames, (Iterable)legacyEmailAccountNames);
        Map emailAccounts = new LinkedHashMap();
        for (String emailAccountName : emailAccountNames) {
            SecureDestinationSettings it;
            if (this.getSecureDestinationSettings(settings, emailAccountName) == null) continue;
            boolean bl = false;
            emailAccounts.put(emailAccountName, it);
        }
        return emailAccounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SecureDestinationSettings getSecureDestinationSettings(Settings settings, String emailAccountName) {
        SecureDestinationSettings secureDestinationSettings;
        SecureString secureString = this.getEmailSettingValue(settings, emailAccountName, EMAIL_USERNAME);
        if (secureString != null) {
            Closeable closeable = (Closeable)secureString;
            Throwable throwable = null;
            try {
                SecureDestinationSettings secureDestinationSettings2;
                SecureString emailUsername = (SecureString)closeable;
                boolean bl = false;
                SecureString secureString2 = INSTANCE.getEmailSettingValue(settings, emailAccountName, EMAIL_PASSWORD);
                if (secureString2 != null) {
                    Closeable closeable2 = (Closeable)secureString2;
                    Throwable throwable2 = null;
                    try {
                        SecureString emailPassword = (SecureString)closeable2;
                        boolean bl2 = false;
                        SecureString secureString3 = emailUsername.clone();
                        Intrinsics.checkNotNullExpressionValue((Object)secureString3, (String)"clone(...)");
                        SecureString secureString4 = emailPassword.clone();
                        Intrinsics.checkNotNullExpressionValue((Object)secureString4, (String)"clone(...)");
                        SecureDestinationSettings secureDestinationSettings3 = new SecureDestinationSettings(secureString3, secureString4);
                        secureDestinationSettings2 = secureDestinationSettings3;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                } else {
                    secureDestinationSettings2 = null;
                }
                SecureDestinationSettings secureDestinationSettings4 = secureDestinationSettings2;
                secureDestinationSettings = secureDestinationSettings4;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            secureDestinationSettings = null;
        }
        return secureDestinationSettings;
    }

    private final <T> T getEmailSettingValue(Settings settings, String emailAccountName, Setting.AffixSetting<T> emailSetting) {
        Setting concreteSetting = emailSetting.getConcreteSettingForNamespace(emailAccountName);
        return (T)concreteSetting.get(settings);
    }

    private final <T> Setting<T> fallback(String key, Setting.AffixSetting<T> affixSetting, String regex, String replacement) {
        Setting setting;
        if (Intrinsics.areEqual((Object)"_na_", (Object)key)) {
            setting = affixSetting.getConcreteSettingForNamespace(key);
        } else {
            CharSequence charSequence = key;
            String string = regex;
            setting = affixSetting.getConcreteSetting(new Regex(string).replace(charSequence, replacement));
        }
        return setting;
    }

    @OpenForTesting
    public final void reset() {
        emailSizeLimit = 10000000;
        emailMinimumHeaderLength = 160;
        maxConnections = 60;
        maxConnectionsPerRoute = 20;
        connectionTimeout = 5000;
        socketTimeout = 50000;
        maxHttpResponseSize = DEFAULT_MAX_HTTP_RESPONSE_SIZE;
        allowedConfigTypes = DEFAULT_ALLOWED_CONFIG_TYPES;
        tooltipSupport = true;
        hostDenyList = DEFAULT_HOST_DENY_LIST;
    }

    private static final String ALLOWED_CONFIG_TYPES$lambda$0(String it) {
        return it;
    }

    private static final String LEGACY_ALERTING_HOST_DENY_LIST$lambda$0(String it) {
        return it;
    }

    private static final String ALERTING_HOST_DENY_LIST$lambda$0(String it) {
        return it;
    }

    private static final String HOST_DENY_LIST$lambda$0(String it) {
        return it;
    }

    private static final Setting LEGACY_EMAIL_USERNAME$lambda$0(String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]);
    }

    private static final Setting LEGACY_EMAIL_PASSWORD$lambda$0(String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]);
    }

    private static final Setting EMAIL_USERNAME$lambda$0(String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return SecureSetting.secureString((String)key, INSTANCE.fallback(key, LEGACY_EMAIL_USERNAME, "opensearch\\.notifications\\.core", "plugins.alerting.destination"), (Setting.Property[])new Setting.Property[0]);
    }

    private static final Setting EMAIL_PASSWORD$lambda$0(String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return SecureSetting.secureString((String)key, INSTANCE.fallback(key, LEGACY_EMAIL_PASSWORD, "opensearch\\.notifications\\.core", "plugins.alerting.destination"), (Setting.Property[])new Setting.Property[0]);
    }

    private static final void addSettingsUpdateConsumer$lambda$0(List it) {
        Intrinsics.checkNotNull((Object)it);
        allowedConfigTypes = it;
        INSTANCE.getLog().info("notifications-core:opensearch.notifications.core.allowed_config_types -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda$1(Integer it) {
        Intrinsics.checkNotNull((Object)it);
        emailSizeLimit = it;
        INSTANCE.getLog().info("notifications-core:opensearch.notifications.core.email.size_limit -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda$2(Integer it) {
        Intrinsics.checkNotNull((Object)it);
        emailMinimumHeaderLength = it;
        INSTANCE.getLog().info("notifications-core:opensearch.notifications.core.email.minimum_header_length -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda$3(Integer it) {
        Intrinsics.checkNotNull((Object)it);
        maxConnections = it;
        INSTANCE.getLog().info("notifications-core:opensearch.notifications.core.http.max_connections -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda$4(Integer it) {
        Intrinsics.checkNotNull((Object)it);
        maxConnectionsPerRoute = it;
        INSTANCE.getLog().info("notifications-core:opensearch.notifications.core.http.max_connection_per_route -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda$5(Integer it) {
        Intrinsics.checkNotNull((Object)it);
        connectionTimeout = it;
        INSTANCE.getLog().info("notifications-core:opensearch.notifications.core.http.connection_timeout -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda$6(Integer it) {
        Intrinsics.checkNotNull((Object)it);
        socketTimeout = it;
        INSTANCE.getLog().info("notifications-core:opensearch.notifications.core.http.socket_timeout -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda$7(Integer it) {
        Intrinsics.checkNotNull((Object)it);
        maxHttpResponseSize = it;
        INSTANCE.getLog().info("notifications-core:opensearch.notifications.core.max_http_response_size -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda$8(Boolean it) {
        Intrinsics.checkNotNull((Object)it);
        tooltipSupport = it;
        INSTANCE.getLog().info("notifications-core:opensearch.notifications.core.tooltip_support -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda$9(List it) {
        Intrinsics.checkNotNull((Object)it);
        hostDenyList = it;
        INSTANCE.getLog().info("notifications-core:opensearch.notifications.core.http.host_deny_list -updatedTo-> " + it);
    }

    static {
        String string;
        String configDirName;
        INSTANCE = new PluginSettings();
        DEFAULT_MAX_HTTP_RESPONSE_SIZE = (int)((ByteSizeValue)HttpTransportSettings.SETTING_HTTP_MAX_CONTENT_LENGTH.getDefault(Settings.EMPTY)).getBytes();
        String[] stringArray = new String[]{"slack", "chime", "microsoft_teams", "webhook", "email", "sns", "ses_account", "smtp_account", "email_group"};
        DEFAULT_ALLOWED_CONFIG_TYPES = CollectionsKt.listOf((Object[])stringArray);
        DEFAULT_HOST_DENY_LIST = CollectionsKt.emptyList();
        DEFAULT_DESTINATION_SETTINGS = MapsKt.emptyMap();
        log$delegate = HelpersKt.logger(INSTANCE.getClass());
        String settings = null;
        Dictionary dictionary = BootstrapInfo.getSystemProperties();
        String string2 = dictionary != null && (dictionary = dictionary.get("opensearch.path.conf")) != null ? dictionary.toString() : (configDirName = null);
        if (configDirName != null) {
            String[] stringArray2 = new String[]{"opensearch-notifications-core", "notifications-core.yml"};
            Path defaultSettingYmlFile = Path.of(configDirName, stringArray2);
            try {
                settings = Settings.builder().loadFromPath(defaultSettingYmlFile).build();
            }
            catch (IOException e) {
                INSTANCE.getLog().warn("notifications-core:Failed to load " + defaultSettingYmlFile.toAbsolutePath() + ":" + e.getMessage());
            }
        }
        emailSizeLimit = (string = settings) != null && (string = string.get(EMAIL_SIZE_LIMIT_KEY)) != null ? Integer.parseInt(string) : 10000000;
        String string3 = settings;
        emailMinimumHeaderLength = string3 != null && (string3 = string3.get(EMAIL_MINIMUM_HEADER_LENGTH_KEY)) != null ? Integer.parseInt(string3) : 160;
        String string4 = settings;
        maxConnections = string4 != null && (string4 = string4.get(MAX_CONNECTIONS_KEY)) != null ? Integer.parseInt(string4) : 60;
        String string5 = settings;
        maxConnectionsPerRoute = string5 != null && (string5 = string5.get(MAX_CONNECTIONS_PER_ROUTE_KEY)) != null ? Integer.parseInt(string5) : 20;
        String string6 = settings;
        connectionTimeout = string6 != null && (string6 = string6.get(CONNECTION_TIMEOUT_MILLISECONDS_KEY)) != null ? Integer.parseInt(string6) : 5000;
        String string7 = settings;
        socketTimeout = string7 != null && (string7 = string7.get(SOCKET_TIMEOUT_MILLISECONDS_KEY)) != null ? Integer.parseInt(string7) : 50000;
        String string8 = settings;
        maxHttpResponseSize = string8 != null && (string8 = string8.get(MAX_HTTP_RESPONSE_SIZE_KEY)) != null ? Integer.parseInt(string8) : DEFAULT_MAX_HTTP_RESPONSE_SIZE;
        Object object = settings;
        if (object == null || (object = object.getAsList(ALLOWED_CONFIG_TYPE_KEY, null)) == null) {
            object = DEFAULT_ALLOWED_CONFIG_TYPES;
        }
        allowedConfigTypes = object;
        Object object2 = settings;
        tooltipSupport = object2 != null && (object2 = object2.getAsBoolean(TOOLTIP_SUPPORT_KEY, Boolean.valueOf(true))) != null ? (Boolean)object2 : true;
        Object object3 = settings;
        if (object3 == null || (object3 = object3.getAsList(HOST_DENY_LIST_KEY, null)) == null) {
            object3 = DEFAULT_HOST_DENY_LIST;
        }
        hostDenyList = object3;
        String string9 = settings;
        if (string9 == null || (string9 = string9.get(CLUSTER_NAME, DEFAULT_CLUSTER_NAME)) == null) {
            string9 = DEFAULT_CLUSTER_NAME;
        }
        clusterName = string9;
        String string10 = settings;
        destinationSettings = string10 != null ? INSTANCE.loadDestinationSettings((Settings)string10) : DEFAULT_DESTINATION_SETTINGS;
        Pair[] pairArray = new Pair[8];
        String string11 = Integer.toString(emailSizeLimit, CharsKt.checkRadix((int)10));
        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"toString(...)");
        pairArray[0] = TuplesKt.to((Object)EMAIL_SIZE_LIMIT_KEY, (Object)string11);
        String string12 = Integer.toString(emailMinimumHeaderLength, CharsKt.checkRadix((int)10));
        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"toString(...)");
        pairArray[1] = TuplesKt.to((Object)EMAIL_MINIMUM_HEADER_LENGTH_KEY, (Object)string12);
        String string13 = Integer.toString(maxConnections, CharsKt.checkRadix((int)10));
        Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"toString(...)");
        pairArray[2] = TuplesKt.to((Object)MAX_CONNECTIONS_KEY, (Object)string13);
        String string14 = Integer.toString(maxConnectionsPerRoute, CharsKt.checkRadix((int)10));
        Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"toString(...)");
        pairArray[3] = TuplesKt.to((Object)MAX_CONNECTIONS_PER_ROUTE_KEY, (Object)string14);
        String string15 = Integer.toString(connectionTimeout, CharsKt.checkRadix((int)10));
        Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"toString(...)");
        pairArray[4] = TuplesKt.to((Object)CONNECTION_TIMEOUT_MILLISECONDS_KEY, (Object)string15);
        String string16 = Integer.toString(socketTimeout, CharsKt.checkRadix((int)10));
        Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"toString(...)");
        pairArray[5] = TuplesKt.to((Object)SOCKET_TIMEOUT_MILLISECONDS_KEY, (Object)string16);
        String string17 = Integer.toString(maxHttpResponseSize, CharsKt.checkRadix((int)10));
        Intrinsics.checkNotNullExpressionValue((Object)string17, (String)"toString(...)");
        pairArray[6] = TuplesKt.to((Object)MAX_HTTP_RESPONSE_SIZE_KEY, (Object)string17);
        pairArray[7] = TuplesKt.to((Object)TOOLTIP_SUPPORT_KEY, (Object)String.valueOf(tooltipSupport));
        defaultSettings = MapsKt.mapOf((Pair[])pairArray);
        String string18 = defaultSettings.get(EMAIL_SIZE_LIMIT_KEY);
        Intrinsics.checkNotNull((Object)string18);
        Setting.Property[] propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        Setting setting = Setting.intSetting((String)EMAIL_SIZE_LIMIT_KEY, (int)Integer.parseInt(string18), (int)10000, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting, (String)"intSetting(...)");
        EMAIL_SIZE_LIMIT = setting;
        String string19 = defaultSettings.get(EMAIL_MINIMUM_HEADER_LENGTH_KEY);
        Intrinsics.checkNotNull((Object)string19);
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        Setting setting2 = Setting.intSetting((String)EMAIL_MINIMUM_HEADER_LENGTH_KEY, (int)Integer.parseInt(string19), (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting2, (String)"intSetting(...)");
        EMAIL_MINIMUM_HEADER_LENGTH = setting2;
        String string20 = defaultSettings.get(MAX_CONNECTIONS_KEY);
        Intrinsics.checkNotNull((Object)string20);
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        Setting setting3 = Setting.intSetting((String)MAX_CONNECTIONS_KEY, (int)Integer.parseInt(string20), (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting3, (String)"intSetting(...)");
        MAX_CONNECTIONS = setting3;
        String string21 = defaultSettings.get(MAX_CONNECTIONS_PER_ROUTE_KEY);
        Intrinsics.checkNotNull((Object)string21);
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        Setting setting4 = Setting.intSetting((String)MAX_CONNECTIONS_PER_ROUTE_KEY, (int)Integer.parseInt(string21), (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting4, (String)"intSetting(...)");
        MAX_CONNECTIONS_PER_ROUTE = setting4;
        String string22 = defaultSettings.get(CONNECTION_TIMEOUT_MILLISECONDS_KEY);
        Intrinsics.checkNotNull((Object)string22);
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        Setting setting5 = Setting.intSetting((String)CONNECTION_TIMEOUT_MILLISECONDS_KEY, (int)Integer.parseInt(string22), (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting5, (String)"intSetting(...)");
        CONNECTION_TIMEOUT_MILLISECONDS = setting5;
        String string23 = defaultSettings.get(SOCKET_TIMEOUT_MILLISECONDS_KEY);
        Intrinsics.checkNotNull((Object)string23);
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        Setting setting6 = Setting.intSetting((String)SOCKET_TIMEOUT_MILLISECONDS_KEY, (int)Integer.parseInt(string23), (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting6, (String)"intSetting(...)");
        SOCKET_TIMEOUT_MILLISECONDS = setting6;
        String string24 = defaultSettings.get(MAX_HTTP_RESPONSE_SIZE_KEY);
        Intrinsics.checkNotNull((Object)string24);
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        Setting setting7 = Setting.intSetting((String)MAX_HTTP_RESPONSE_SIZE_KEY, (int)Integer.parseInt(string24), (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting7, (String)"intSetting(...)");
        MAX_HTTP_RESPONSE_SIZE = setting7;
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        Setting setting8 = Setting.listSetting((String)ALLOWED_CONFIG_TYPE_KEY, DEFAULT_ALLOWED_CONFIG_TYPES, PluginSettings::ALLOWED_CONFIG_TYPES$lambda$0, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting8, (String)"listSetting(...)");
        ALLOWED_CONFIG_TYPES = setting8;
        String string25 = defaultSettings.get(TOOLTIP_SUPPORT_KEY);
        Intrinsics.checkNotNull((Object)string25);
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        Setting setting9 = Setting.boolSetting((String)TOOLTIP_SUPPORT_KEY, (boolean)Boolean.parseBoolean(string25), (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting9, (String)"boolSetting(...)");
        TOOLTIP_SUPPORT = setting9;
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Final, Setting.Property.Deprecated};
        Setting setting10 = Setting.listSetting((String)LEGACY_ALERTING_HOST_DENY_LIST_KEY, DEFAULT_HOST_DENY_LIST, PluginSettings::LEGACY_ALERTING_HOST_DENY_LIST$lambda$0, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting10, (String)"listSetting(...)");
        LEGACY_ALERTING_HOST_DENY_LIST = setting10;
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Final};
        stringArray = Setting.listSetting((String)ALERTING_HOST_DENY_LIST_KEY, LEGACY_ALERTING_HOST_DENY_LIST, PluginSettings::ALERTING_HOST_DENY_LIST$lambda$0, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"listSetting(...)");
        ALERTING_HOST_DENY_LIST = stringArray;
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        stringArray = Setting.listSetting((String)HOST_DENY_LIST_KEY, ALERTING_HOST_DENY_LIST, PluginSettings::HOST_DENY_LIST$lambda$0, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"listSetting(...)");
        HOST_DENY_LIST = stringArray;
        Setting.AffixSetting affixSetting = Setting.affixKeySetting((String)LEGACY_EMAIL_DESTINATION_SETTING_PREFIX, (String)"username", PluginSettings::LEGACY_EMAIL_USERNAME$lambda$0, (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        Intrinsics.checkNotNullExpressionValue((Object)affixSetting, (String)"affixKeySetting(...)");
        LEGACY_EMAIL_USERNAME = affixSetting;
        Setting.AffixSetting affixSetting2 = Setting.affixKeySetting((String)LEGACY_EMAIL_DESTINATION_SETTING_PREFIX, (String)"password", PluginSettings::LEGACY_EMAIL_PASSWORD$lambda$0, (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        Intrinsics.checkNotNullExpressionValue((Object)affixSetting2, (String)"affixKeySetting(...)");
        LEGACY_EMAIL_PASSWORD = affixSetting2;
        Setting.AffixSetting affixSetting3 = Setting.affixKeySetting((String)EMAIL_DESTINATION_SETTING_PREFIX, (String)"username", PluginSettings::EMAIL_USERNAME$lambda$0, (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        Intrinsics.checkNotNullExpressionValue((Object)affixSetting3, (String)"affixKeySetting(...)");
        EMAIL_USERNAME = affixSetting3;
        Setting.AffixSetting affixSetting4 = Setting.affixKeySetting((String)EMAIL_DESTINATION_SETTING_PREFIX, (String)"password", PluginSettings::EMAIL_PASSWORD$lambda$0, (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        Intrinsics.checkNotNullExpressionValue((Object)affixSetting4, (String)"affixKeySetting(...)");
        EMAIL_PASSWORD = affixSetting4;
    }
}

