/**
 * Krill Installer - Simplified Refactoring
 * ./src/krill/prepare.ts
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import Keyboards from '../../classes/keyboards.js';
import Locales from '../../classes/locales.js';
import { IKrillConfig } from '../interfaces/i_krill_config.js';
import { keyboard } from './prepare.d/keyboard.js';
import { location } from './prepare.d/location.js';
import { network } from './prepare.d/network.js';
import { partitions } from './prepare.d/partitions.js';
import { summary } from './prepare.d/summary.js';
import { users } from './prepare.d/users.js';
import { welcome } from './prepare.d/welcome.js';
/**
 * Main Krill installer class - Simplified refactoring
 */
export default class Krill {
    chroot: boolean;
    halt: boolean;
    keyboard: typeof keyboard;
    keyboards: Keyboards;
    krillConfig: IKrillConfig;
    locales: Locales;
    location: typeof location;
    network: typeof network;
    nointeractive: boolean;
    partitions: typeof partitions;
    summary: typeof summary;
    unattended: boolean;
    users: typeof users;
    welcome: typeof welcome;
    /**
     * Constructor
     */
    constructor(unattended?: boolean, nointeractive?: boolean, halt?: boolean, chroot?: boolean);
    /**
     * Main prepare method - Simplified and cleaner
     */
    prepare(krillConfig?: IKrillConfig, ip?: boolean, random?: boolean, domain?: string, suspend?: boolean, small?: boolean, none?: boolean, crypted?: boolean, pve?: boolean, btrfs?: boolean, replace?: string, testing?: boolean, verbose?: boolean): Promise<void>;
    /**
     * Apply options for unattended installation
     */
    private applyUnattendedOptions;
    /**
     * Auto-configure timezone from internet
     */
    private autoConfigureTimezone;
    /**
     * Build default configurations
     */
    private buildConfigurations;
    /**
     * Check system requirements (disks, LVM)
     */
    private checkSystemRequirements;
    /**
     * Create script to remove LVM partitions
     */
    private createLvmRemovalScript;
    /**
     * Generate hostname based on options
     */
    private generateHostname;
    /**
     * Perform installation or testing
     */
    private performInstallation;
    /**
     * Check if Physical Volumes exist
     */
    private pvExist;
    /**
     * Run interactive mode with UI
     */
    private runInteractiveMode;
    /**
     * Setup configuration files and auto-configure timezone
     */
    private setupConfiguration;
    /**
     * Stop system services
     */
    private stopSystemServices;
}
