\name{NoiseImageFilter}
\alias{NoiseImageFilter}
\title{NoiseImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Calculate the local noise in an image.
NoiseImageFilter}
\details{
Computes an image where a given pixel is the standard deviation of the
pixels in a neighborhood about the corresponding input pixel. This
serves as an estimate of the local noise (or texture) in an image.
Currently, this noise estimate assume a piecewise constant image. This
filter should be extended to fitting a (hyper) plane to the
neighborhood and calculating the standard deviation of the residuals
to this (hyper) plane.
See:
Image
Neighborhood
NeighborhoodOperator
NeighborhoodIterator
Noise for the procedural interface
itk::NoiseImageFilter for the Doxygen on the original ITK class.
NoiseImageFilter}
%C++ includes: sitkNoiseImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::vector< unsigned int > GetRadius() const:}{}
\item{ NoiseImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetRadius(std::vector< unsigned int > Radius):}{}
\item{Self SetRadius(unsigned int value):}{
Set the values of the Radius vector all to value
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~NoiseImageFilter():}{
Destructor
}
}
}
