/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.CreateAsyncFromSyncIteratorNode;
import com.oracle.truffle.js.nodes.access.GetAsyncIteratorNodeGen;
import com.oracle.truffle.js.nodes.access.GetIteratorFromMethodNode;
import com.oracle.truffle.js.nodes.access.GetIteratorNode;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Set;

@ImportStatic(value={Symbol.class})
public abstract class GetAsyncIteratorNode
extends JavaScriptNode {
    @Node.Child
    @Executed
    protected JavaScriptNode objectNode;

    protected GetAsyncIteratorNode(JavaScriptNode objectNode) {
        this.objectNode = objectNode;
    }

    @NeverDefault
    public static GetAsyncIteratorNode create() {
        return GetAsyncIteratorNodeGen.create(null);
    }

    @NeverDefault
    public static GetAsyncIteratorNode create(JavaScriptNode iteratedObject) {
        return GetAsyncIteratorNodeGen.create(iteratedObject);
    }

    @Specialization
    protected final IteratorRecord doGetIterator(Object iteratedObject, @Cached(inline=true) GetIteratorNode getIteratorNode, @Cached GetIteratorFromMethodNode getIteratorFromMethodNode, @Cached(value="create(getJSContext(), SYMBOL_ASYNC_ITERATOR)") GetMethodNode getAsyncIteratorMethodNode, @Cached CreateAsyncFromSyncIteratorNode createAsyncFromSyncIteratorNode, @Cached InlinedConditionProfile asyncToSync) {
        Object usingAsyncIterator = getAsyncIteratorMethodNode.executeWithTarget(iteratedObject);
        if (asyncToSync.profile((Node)this, usingAsyncIterator == Undefined.instance)) {
            IteratorRecord syncIteratorRecord = getIteratorNode.execute(this, iteratedObject);
            return createAsyncFromSyncIteratorNode.execute(this, syncIteratorRecord);
        }
        return getIteratorFromMethodNode.execute(this, iteratedObject, usingAsyncIterator);
    }

    @Override
    public abstract IteratorRecord execute(VirtualFrame var1);

    public abstract IteratorRecord execute(Object var1);

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return GetAsyncIteratorNodeGen.create(GetAsyncIteratorNode.cloneUninitialized(this.objectNode, materializedTags));
    }
}

