/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.server.db2;

import java.util.Set;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.databaseconnector.DatabaseConnectorOptions;
import schemacrawler.tools.databaseconnector.DatabaseConnectorOptionsBuilder;
import schemacrawler.tools.executable.commandline.PluginCommand;
import us.fatehi.utility.datasource.DatabaseConnectionSourceBuilder;
import us.fatehi.utility.datasource.DatabaseServerType;

public final class DB2DatabaseConnector
extends DatabaseConnector {
    private static DatabaseConnectorOptions databaseConnectorOptions() {
        DatabaseServerType dbServerType = new DatabaseServerType("db2", "IBM DB2");
        DatabaseConnectionSourceBuilder connectionSourceBuilder = DatabaseConnectionSourceBuilder.builder((String)"jdbc:db2://${host}:${port}/${database}").withDefaultPort(50000).withDefaultUrlx("retrieveMessagesFromServerOnGetMessage", true).withAdditionalDriverProperties(Set.of("affinityFailbackInterval", "allowNextOnExhaustedResultSet", "allowNullResultSetForExecuteQuery", "atomicMultiRowInsert", "autocommit", "blockingReadConnectionTimeout", "clientBidiStringType", "clientDebugInfo", "clientRerouteAlternateServerName", "clientRerouteAlternatePortNumber", "clientRerouteServerListJNDIName", "clientRerouteServerListJNDIContext", "commandTimeout", "connectionCloseWithInFlightTransaction", "connectionTimeout", "databaseName", "decimalSeparator", "decimalStringFormat", "defaultIsolationLevel", "deferPrepares", "description", "downgradeHoldCursorsUnderXa", "driverType", "enableClientAffinitiesList", "enableNamedParameterMarkers", "enableBidiLayoutTransformation", "enableSeamlessFailover", "enableSysplexWLB", "fetchSize", "fullyMaterializeLobData", "implicitRollbackOption", "interruptProcessingMode", "keepAliveTimeOut", "loginTimeout", "logWriter", "maxRetriesForClientReroute", "memberConnectTimeout", "progressiveStreaming", "queryCloseImplicit", "queryDataSize", "queryTimeoutInterruptProcessingMode", "receiveBufferSize", "retrieveMessagesFromServerOnGetMessage", "retryIntervalForClientReroute", "securityMechanism", "sendDataAsIs", "serverBidiStringType", "serverName", "sslConnection", "sslTrustStoreLocation", "sslTrustStorePassword", "sslTrustStoreType", "sslKeyStoreLocation", "sslKeyStorePassword", "sslKeyStoreType", "sslVersion", "streamBufferSize", "traceDirectory", "traceFile", "traceFileAppend", "traceLevel", "translateForBitData", "translateBinary", "useCachedCursor", "useJDBC4ColumnNameAndLabelSemantics"));
        PluginCommand pluginCommand = PluginCommand.newDatabasePluginCommand((DatabaseServerType)dbServerType);
        pluginCommand.addOption("server", String.class, new String[]{"--server=db2%nLoads SchemaCrawler plug-in for IBM DB2"}).addOption("host", String.class, new String[]{"Host name%nOptional, defaults to localhost"}).addOption("port", Integer.class, new String[]{"Port number%nOptional, defaults to 50000"}).addOption("database", String.class, new String[]{"Database name"});
        return (DatabaseConnectorOptions)DatabaseConnectorOptionsBuilder.builder((DatabaseServerType)dbServerType).withHelpCommand(pluginCommand).withUrlStartsWith("jdbc:db2:").withInformationSchemaViewsFromResourceFolder("/db2.information_schema").withDatabaseConnectionSourceBuilder(() -> connectionSourceBuilder).build();
    }

    public DB2DatabaseConnector() {
        super(DB2DatabaseConnector.databaseConnectorOptions());
    }
}

