/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

class ByteBufferUtilsUnsafe {
    private static final StringManager sm;
    private static final Log log;
    private static final Object unsafe;
    private static final Method invokeCleanerMethod;

    private ByteBufferUtilsUnsafe() {
    }

    static void cleanDirectBuffer(ByteBuffer byteBuffer) {
        block3: {
            if (invokeCleanerMethod != null) {
                try {
                    invokeCleanerMethod.invoke(unsafe, byteBuffer);
                }
                catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException exception) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)sm.getString("byteBufferUtils.cleaner"), (Throwable)exception);
                }
            }
        }
    }

    static {
        Method method;
        Object object;
        sm = StringManager.getManager(ByteBufferUtilsUnsafe.class);
        log = LogFactory.getLog(ByteBufferUtilsUnsafe.class);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(0);
        try {
            Class<?> clazz = Class.forName("sun.misc.Unsafe");
            Field field = clazz.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            object = field.get(null);
            method = clazz.getMethod("invokeCleaner", ByteBuffer.class);
            method.invoke(object, byteBuffer);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            log.warn((Object)sm.getString("byteBufferUtils.cleaner"), (Throwable)exception);
            object = null;
            method = null;
        }
        unsafe = object;
        invokeCleanerMethod = method;
    }
}

