/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimppalette_pdb.h
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#if !defined (__GIMP_H_INSIDE__) && !defined (GIMP_COMPILATION)
#error "Only <libgimp/gimp.h> can be included directly."
#endif

#ifndef __GIMP_PALETTE_PDB_H__
#define __GIMP_PALETTE_PDB_H__

G_BEGIN_DECLS

/* For information look into the C source or the html documentation */


GimpPalette*             gimp_palette_new             (const gchar  *name);
GimpPalette*             gimp_palette_get_by_name     (const gchar  *name);
gint                     gimp_palette_get_color_count (GimpPalette  *palette);
GeglColor**              gimp_palette_get_colors      (GimpPalette  *palette);
gint                     gimp_palette_get_columns     (GimpPalette  *palette);
gboolean                 gimp_palette_set_columns     (GimpPalette  *palette,
                                                       gint          columns);
gboolean                 gimp_palette_add_entry       (GimpPalette  *palette,
                                                       const gchar  *entry_name,
                                                       GeglColor    *color,
                                                       gint         *entry_num);
gboolean                 gimp_palette_delete_entry    (GimpPalette  *palette,
                                                       gint          entry_num);
GeglColor*               gimp_palette_get_entry_color (GimpPalette  *palette,
                                                       gint          entry_num);
gboolean                 gimp_palette_set_entry_color (GimpPalette  *palette,
                                                       gint          entry_num,
                                                       GeglColor    *color);
gboolean                 gimp_palette_get_entry_name  (GimpPalette  *palette,
                                                       gint          entry_num,
                                                       gchar       **entry_name);
gboolean                 gimp_palette_set_entry_name  (GimpPalette  *palette,
                                                       gint          entry_num,
                                                       const gchar  *entry_name);
G_GNUC_INTERNAL GBytes*  _gimp_palette_get_bytes      (GimpPalette  *palette,
                                                       const Babl   *format,
                                                       gint         *num_colors);
G_GNUC_INTERNAL gboolean _gimp_palette_set_bytes      (GimpPalette  *palette,
                                                       const Babl   *format,
                                                       GBytes       *colormap);


G_END_DECLS

#endif /* __GIMP_PALETTE_PDB_H__ */
