/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.maven.server.m40.utils;

import com.intellij.util.ExceptionUtilRt;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.eventspy.AbstractEventSpy;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.artifact.Artifact;
import org.jetbrains.idea.maven.server.MavenServerConsoleIndicator;

@Named(value="Intellij Idea Maven 4 Importer Spy")
@Singleton
public class Maven40ImporterSpy
extends AbstractEventSpy {
    private volatile MavenServerConsoleIndicator myIndicator;
    private final Set<String> downloadedArtifacts = Collections.newSetFromMap(new ConcurrentHashMap());

    public void onEvent(Object o) throws Exception {
        String dependencyId;
        if (!(o instanceof RepositoryEvent)) {
            return;
        }
        RepositoryEvent event = (RepositoryEvent)o;
        if (event.getArtifact() == null) {
            return;
        }
        MavenServerConsoleIndicator indicator = this.myIndicator;
        if (indicator == null) {
            return;
        }
        if (event.getType() == RepositoryEvent.EventType.ARTIFACT_DOWNLOADING) {
            String dependencyId2 = Maven40ImporterSpy.toString(event.getArtifact());
            indicator.startedDownload(MavenServerConsoleIndicator.ResolveType.DEPENDENCY, dependencyId2);
            this.downloadedArtifacts.add(dependencyId2);
        } else if (event.getType() == RepositoryEvent.EventType.ARTIFACT_RESOLVED && this.downloadedArtifacts.remove(dependencyId = Maven40ImporterSpy.toString(event.getArtifact()))) {
            Maven40ImporterSpy.processResolvedArtifact(event, indicator, dependencyId);
        }
    }

    private static void processResolvedArtifact(RepositoryEvent event, MavenServerConsoleIndicator indicator, String dependencyId) throws RemoteException {
        if (event.getExceptions() != null && !event.getExceptions().isEmpty()) {
            StringBuilder builder = new StringBuilder();
            for (Exception e : event.getExceptions()) {
                String stackTrace = ExceptionUtilRt.getThrowableText((Throwable)e, (String)"com.jetbrains");
                builder.append(stackTrace).append("\n");
            }
            indicator.failedDownload(MavenServerConsoleIndicator.ResolveType.DEPENDENCY, dependencyId, event.getException().getMessage(), builder.toString());
        } else {
            indicator.completedDownload(MavenServerConsoleIndicator.ResolveType.DEPENDENCY, dependencyId);
        }
    }

    public void close() {
        this.downloadedArtifacts.clear();
    }

    private static String toString(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getClassifier() + ":" + artifact.getVersion();
    }

    public void setIndicator(MavenServerConsoleIndicator indicator) {
        this.myIndicator = indicator;
    }
}

