/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.util;

import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.fs.util.ZipUtils;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;

public final class ArtifactInfoUtil {
    public static final String DEPLOYMENT = "-deployment";

    @Deprecated
    public static Map.Entry<String, String> groupIdAndArtifactId(Class<?> clazz) {
        return ArtifactInfoUtil.groupIdAndArtifactId(clazz, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map.Entry<String, String> groupIdAndArtifactId(Class<?> clazz, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        try {
            URL codeLocation = clazz.getProtectionDomain().getCodeSource().getLocation();
            if (curateOutcomeBuildItem != null) {
                Path path = Paths.get(codeLocation.toURI());
                String pathAsString = path.toString();
                boolean isJar = pathAsString.endsWith(".jar");
                for (ResolvedDependency i : curateOutcomeBuildItem.getApplicationModel().getDependencies()) {
                    if (isJar && !pathAsString.contains(i.getArtifactId())) continue;
                    for (Path p : i.getResolvedPaths()) {
                        if (!path.equals(p)) continue;
                        String artifactId = i.getArtifactId();
                        if (!artifactId.endsWith(DEPLOYMENT)) return new AbstractMap.SimpleEntry<String, String>(i.getGroupId(), artifactId);
                        artifactId = artifactId.substring(0, artifactId.length() - DEPLOYMENT.length());
                        return new AbstractMap.SimpleEntry<String, String>(i.getGroupId(), artifactId);
                    }
                }
            }
            if (codeLocation.toString().endsWith(".jar")) {
                try (FileSystem fs = ZipUtils.newFileSystem((Path)Paths.get(codeLocation.toURI()), (ClassLoader)Thread.currentThread().getContextClassLoader());){
                    Map.Entry<String, String> ret = ArtifactInfoUtil.groupIdAndArtifactId(fs);
                    if (ret == null) {
                        throw new RuntimeException("Unable to determine groupId and artifactId of the jar that contains " + clazz.getName() + " because the jar doesn't contain the necessary metadata");
                    }
                    Map.Entry<String, String> isJar = ret;
                    return isJar;
                }
            }
            if (!"file".equals(codeLocation.getProtocol())) return new AbstractMap.SimpleEntry<String, String>("unspecified", "unspecified");
            Path location = Paths.get(codeLocation.toURI());
            while (!ArtifactInfoUtil.isDeploymentTargetClasses(location) && location.getParent() != null) {
                location = location.getParent();
            }
            if (location == null) return new AbstractMap.SimpleEntry<String, String>("unspecified", "unspecified");
            Path mavenArchiver = location.getParent().resolve("maven-archiver");
            if (!mavenArchiver.toFile().canRead()) return new AbstractMap.SimpleEntry<String, String>("unspecified", "unspecified");
            AbstractMap.SimpleEntry<String, String> ret = ArtifactInfoUtil.groupIdAndArtifactId(mavenArchiver);
            if (ret != null) return ret;
            throw new RuntimeException("Unable to determine groupId and artifactId of the extension that contains " + clazz.getName() + " because the directory doesn't contain the necessary metadata");
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException("Unable to determine groupId and artifactId of the jar that contains " + clazz.getName(), e);
        }
    }

    static boolean isDeploymentTargetClasses(Path location) {
        if (!location.getFileName().toString().equals("classes")) {
            return false;
        }
        Path target = location.getParent();
        if (target == null || !target.getFileName().toString().equals("target")) {
            return false;
        }
        Path deployment = location.getParent().getParent();
        return deployment != null && deployment.getFileName().toString().equals("deployment");
    }

    public static Map.Entry<String, String> groupIdAndArtifactId(FileSystem fs) throws IOException {
        Path metaInfPath = fs.getPath("/META-INF", new String[0]);
        return ArtifactInfoUtil.groupIdAndArtifactId(metaInfPath);
    }

    public static AbstractMap.SimpleEntry<String, String> groupIdAndArtifactId(Path pomPropertiesContainer) throws IOException {
        Optional<Path> pomProperties = Files.walk(pomPropertiesContainer, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith("pom.properties")).findFirst();
        if (pomProperties.isPresent()) {
            Properties props = new Properties();
            props.load(Files.newInputStream(pomProperties.get(), new OpenOption[0]));
            String artifactId = props.getProperty("artifactId");
            if (artifactId.endsWith(DEPLOYMENT)) {
                artifactId = artifactId.substring(0, artifactId.length() - DEPLOYMENT.length());
            }
            return new AbstractMap.SimpleEntry<String, String>(props.getProperty("groupId"), artifactId);
        }
        return null;
    }
}

