/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime;

import io.netty.util.AsciiString;
import io.quarkus.vertx.http.runtime.ProxyConfig;
import io.quarkus.vertx.http.runtime.TrustedProxyCheck;
import java.util.Collection;
import java.util.List;

public class ForwardingProxyOptions {
    public final boolean proxyAddressForwarding;
    final boolean allowForwarded;
    final boolean allowXForwarded;
    final boolean enableForwardedHost;
    final boolean enableForwardedPrefix;
    final AsciiString forwardedHostHeader;
    final AsciiString forwardedPrefixHeader;
    final boolean strictForwardedControl;
    final ProxyConfig.ForwardedPrecedence forwardedPrecedence;
    public final TrustedProxyCheck.TrustedProxyCheckBuilder trustedProxyCheckBuilder;
    final boolean enableTrustedProxyHeader;

    public ForwardingProxyOptions(boolean proxyAddressForwarding, boolean allowForwarded, boolean allowXForwarded, boolean enableForwardedHost, boolean enableTrustedProxyHeader, AsciiString forwardedHostHeader, boolean enableForwardedPrefix, boolean strictForwardedControl, ProxyConfig.ForwardedPrecedence forwardedPrecedence, AsciiString forwardedPrefixHeader, TrustedProxyCheck.TrustedProxyCheckBuilder trustedProxyCheckBuilder) {
        this.proxyAddressForwarding = proxyAddressForwarding;
        this.allowForwarded = allowForwarded;
        this.allowXForwarded = allowXForwarded;
        this.enableForwardedHost = enableForwardedHost;
        this.enableForwardedPrefix = enableForwardedPrefix;
        this.forwardedHostHeader = forwardedHostHeader;
        this.forwardedPrefixHeader = forwardedPrefixHeader;
        this.strictForwardedControl = strictForwardedControl;
        this.forwardedPrecedence = forwardedPrecedence;
        this.trustedProxyCheckBuilder = trustedProxyCheckBuilder;
        this.enableTrustedProxyHeader = enableTrustedProxyHeader;
    }

    public static ForwardingProxyOptions from(ProxyConfig proxyConfig) {
        boolean proxyAddressForwarding = proxyConfig.proxyAddressForwarding();
        boolean allowForwarded = proxyConfig.allowForwarded();
        boolean allowXForwarded = proxyConfig.allowXForwarded().orElse(!allowForwarded);
        boolean enableForwardedHost = proxyConfig.enableForwardedHost();
        boolean enableForwardedPrefix = proxyConfig.enableForwardedPrefix();
        boolean enableTrustedProxyHeader = proxyConfig.enableTrustedProxyHeader();
        boolean strictForwardedControl = proxyConfig.strictForwardedControl();
        ProxyConfig.ForwardedPrecedence forwardedPrecedence = proxyConfig.forwardedPrecedence();
        AsciiString forwardedPrefixHeader = AsciiString.cached((String)proxyConfig.forwardedPrefixHeader());
        AsciiString forwardedHostHeader = AsciiString.cached((String)proxyConfig.forwardedHostHeader());
        List<TrustedProxyCheck.TrustedProxyCheckPart> parts = proxyConfig.trustedProxies().isPresent() ? List.copyOf((Collection)proxyConfig.trustedProxies().get()) : List.of();
        TrustedProxyCheck.TrustedProxyCheckBuilder proxyCheckBuilder = !allowXForwarded && !allowForwarded || parts.isEmpty() ? null : TrustedProxyCheck.TrustedProxyCheckBuilder.builder(parts);
        return new ForwardingProxyOptions(proxyAddressForwarding, allowForwarded, allowXForwarded, enableForwardedHost, enableTrustedProxyHeader, forwardedHostHeader, enableForwardedPrefix, strictForwardedControl, forwardedPrecedence, forwardedPrefixHeader, proxyCheckBuilder);
    }
}

