/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Function;

public final class MultiDistinctByKeyOp<T, K>
extends AbstractMultiOperator<T, T> {
    private final Function<T, K> keyExtractor;

    public MultiDistinctByKeyOp(Multi<? extends T> upstream, Function<T, K> keyExtractor) {
        super(upstream);
        this.keyExtractor = keyExtractor;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> subscriber) {
        this.upstream.subscribe(new DistinctByKeyProcessor<T, K>(ParameterValidation.nonNullNpe(subscriber, "subscriber"), this.keyExtractor));
    }

    static final class DistinctByKeyProcessor<T, K>
    extends MultiOperatorProcessor<T, T> {
        private final Collection<K> foundKeys = new HashSet<K>();
        private final Function<T, K> keyExtractor;

        DistinctByKeyProcessor(MultiSubscriber<? super T> downstream, Function<T, K> keyExtractor) {
            super(downstream);
            this.keyExtractor = keyExtractor;
        }

        @Override
        public void onItem(T t) {
            boolean added;
            if (this.isDone()) {
                return;
            }
            try {
                added = this.foundKeys.add(this.keyExtractor.apply(t));
            }
            catch (Throwable e) {
                this.failAndCancel(e);
                return;
            }
            if (added) {
                this.downstream.onItem(t);
            } else {
                this.request(1L);
            }
        }

        @Override
        public void onFailure(Throwable t) {
            super.onFailure(t);
            this.foundKeys.clear();
        }

        @Override
        public void onCompletion() {
            super.onCompletion();
            this.foundKeys.clear();
        }

        @Override
        public void cancel() {
            super.cancel();
            this.foundKeys.clear();
        }
    }
}

