/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteKeyPairResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DeleteKeyPairResponse> {
    private static final SdkField<Boolean> RETURN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Return").getter(DeleteKeyPairResponse.getter(DeleteKeyPairResponse::returnValue)).setter(DeleteKeyPairResponse.setter(Builder::returnValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Return").unmarshallLocationName("return").build()}).build();
    private static final SdkField<String> KEY_PAIR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyPairId").getter(DeleteKeyPairResponse.getter(DeleteKeyPairResponse::keyPairId)).setter(DeleteKeyPairResponse.setter(Builder::keyPairId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPairId").unmarshallLocationName("keyPairId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETURN_FIELD, KEY_PAIR_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteKeyPairResponse.memberNameToFieldInitializer();
    private final Boolean returnValue;
    private final String keyPairId;

    private DeleteKeyPairResponse(BuilderImpl builder) {
        super(builder);
        this.returnValue = builder.returnValue;
        this.keyPairId = builder.keyPairId;
    }

    public final Boolean returnValue() {
        return this.returnValue;
    }

    public final String keyPairId() {
        return this.keyPairId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.returnValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPairId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteKeyPairResponse)) {
            return false;
        }
        DeleteKeyPairResponse other = (DeleteKeyPairResponse)((Object)obj);
        return Objects.equals(this.returnValue(), other.returnValue()) && Objects.equals(this.keyPairId(), other.keyPairId());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteKeyPairResponse").add("Return", (Object)this.returnValue()).add("KeyPairId", (Object)this.keyPairId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Return": {
                return Optional.ofNullable(clazz.cast(this.returnValue()));
            }
            case "KeyPairId": {
                return Optional.ofNullable(clazz.cast(this.keyPairId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Return", RETURN_FIELD);
        map.put("KeyPairId", KEY_PAIR_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteKeyPairResponse, T> g) {
        return obj -> g.apply((DeleteKeyPairResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private Boolean returnValue;
        private String keyPairId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteKeyPairResponse model) {
            super(model);
            this.returnValue(model.returnValue);
            this.keyPairId(model.keyPairId);
        }

        public final Boolean getReturnValue() {
            return this.returnValue;
        }

        public final void setReturnValue(Boolean returnValue) {
            this.returnValue = returnValue;
        }

        @Override
        public final Builder returnValue(Boolean returnValue) {
            this.returnValue = returnValue;
            return this;
        }

        public final String getKeyPairId() {
            return this.keyPairId;
        }

        public final void setKeyPairId(String keyPairId) {
            this.keyPairId = keyPairId;
        }

        @Override
        public final Builder keyPairId(String keyPairId) {
            this.keyPairId = keyPairId;
            return this;
        }

        @Override
        public DeleteKeyPairResponse build() {
            return new DeleteKeyPairResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteKeyPairResponse> {
        public Builder returnValue(Boolean var1);

        public Builder keyPairId(String var1);
    }
}

