/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.process.ProcessHandler;
import com.jetbrains.python.run.PyDebugProcessHandler;
import com.jetbrains.python.run.PythonProcessHandler;

public final class PythonProcessRunner {
    private PythonProcessRunner() {
    }

    public static ProcessHandler createProcess(GeneralCommandLine commandLine, boolean softKillOnWin) throws ExecutionException {
        if (PythonProcessRunner.isUnderDebugger(commandLine)) {
            return new PyDebugProcessHandler(commandLine);
        }
        return new PythonProcessHandler(commandLine);
    }

    public static ProcessHandler createProcess(GeneralCommandLine commandLine) throws ExecutionException {
        return PythonProcessRunner.createProcess(commandLine, PythonProcessHandler.softKillOnWin());
    }

    public static ProcessHandler createProcessHandlingCtrlC(GeneralCommandLine commandLine) throws ExecutionException {
        return PythonProcessRunner.createProcess(commandLine, true);
    }

    private static boolean isUnderDebugger(GeneralCommandLine commandLine) {
        ParamsGroup debugParams = commandLine.getParametersList().getParamsGroup("Debugger");
        return debugParams != null && !debugParams.getParameters().isEmpty();
    }
}

