/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.paint;

import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.paint.HeadNodePainterKt;
import com.intellij.vcs.log.paint.PaintParameters;
import java.awt.Color;
import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ.\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/vcs/log/paint/HeadNodePainter;", "", "scaleContext", "Lcom/intellij/ui/scale/ScaleContext;", "selectedLineThickness", "", "lineThickness", "rowHeight", "", "<init>", "(Lcom/intellij/ui/scale/ScaleContext;FFI)V", "rawOuterCircleDiameter", "", "outerCircleDiameter", "outerCircleRadius", "selectedOuterCircleDiameter", "selectedOuterCircleRadius", "delta", "paint", "", "g2", "Ljava/awt/Graphics2D;", "xCenter", "yCenter", "isSelected", "", "commitStyle", "Lcom/intellij/vcs/log/VcsLogHighlighter$VcsCommitStyle;", "Companion", "intellij.platform.vcs.log.impl"})
public final class HeadNodePainter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double rawOuterCircleDiameter;
    private final double outerCircleDiameter;
    private final double outerCircleRadius;
    private final double selectedOuterCircleDiameter;
    private final double selectedOuterCircleRadius;
    private final double delta;
    private static final int RADIUS_DELTA = 2;

    public HeadNodePainter(@NotNull ScaleContext scaleContext, float selectedLineThickness, float lineThickness, int rowHeight) {
        Intrinsics.checkNotNullParameter((Object)scaleContext, (String)"scaleContext");
        this.rawOuterCircleDiameter = (double)2 * PaintParameters.scaleWithRowHeight(6, rowHeight);
        this.outerCircleDiameter = PaintUtil.alignToInt((double)this.rawOuterCircleDiameter, (ScaleContext)scaleContext, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.FLOOR, (PaintUtil.ParityMode)PaintUtil.ParityMode.ODD);
        this.outerCircleRadius = PaintUtil.alignToInt((double)(this.outerCircleDiameter / (double)2), (ScaleContext)scaleContext, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.FLOOR, null);
        this.selectedOuterCircleDiameter = this.outerCircleDiameter + (double)selectedLineThickness - (double)lineThickness;
        this.selectedOuterCircleRadius = PaintUtil.alignToInt((double)(this.selectedOuterCircleDiameter / (double)2), (ScaleContext)scaleContext, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.FLOOR, null);
        this.delta = PaintUtil.alignToInt((double)PaintParameters.scaleWithRowHeight(2, rowHeight), (ScaleContext)scaleContext, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.FLOOR, null);
    }

    public final void paint(@NotNull Graphics2D g2, double xCenter, double yCenter, boolean isSelected, @NotNull VcsLogHighlighter.VcsCommitStyle commitStyle) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        Intrinsics.checkNotNullParameter((Object)commitStyle, (String)"commitStyle");
        if (isSelected) {
            HeadNodePainterKt.access$fillCircle(g2, xCenter - this.selectedOuterCircleRadius, yCenter - this.selectedOuterCircleRadius, this.selectedOuterCircleDiameter);
            return;
        }
        Ref.DoubleRef x = new Ref.DoubleRef();
        x.element = xCenter - this.outerCircleRadius;
        Ref.DoubleRef y = new Ref.DoubleRef();
        y.element = yCenter - this.outerCircleRadius;
        Ref.DoubleRef diameter = new Ref.DoubleRef();
        diameter.element = this.outerCircleDiameter;
        HeadNodePainterKt.access$fillCircle(g2, x.element, y.element, diameter.element);
        HeadNodePainter.paint$shrinkDiameter(diameter, x, y, this.delta);
        Color nodeColor = g2.getColor();
        g2.setColor(commitStyle.getBackground());
        HeadNodePainterKt.access$fillCircle(g2, x.element, y.element, diameter.element);
        HeadNodePainter.paint$shrinkDiameter(diameter, x, y, this.delta);
        g2.setColor(nodeColor);
        HeadNodePainterKt.access$fillCircle(g2, x.element, y.element, diameter.element);
    }

    private static final void paint$shrinkDiameter(Ref.DoubleRef diameter, Ref.DoubleRef x, Ref.DoubleRef y, double delta) {
        diameter.element -= delta * (double)2;
        x.element += delta;
        y.element += delta;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/vcs/log/paint/HeadNodePainter$Companion;", "", "<init>", "()V", "RADIUS_DELTA", "", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

