/* Generated by wayland-scanner 1.24.0 */

#ifndef XDG_SYSTEM_BELL_V1_CLIENT_PROTOCOL_H
#define XDG_SYSTEM_BELL_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client-core.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_xdg_system_bell_v1 The xdg_system_bell_v1 protocol
 * @section page_ifaces_xdg_system_bell_v1 Interfaces
 * - @subpage page_iface_xdg_system_bell_v1 - system bell
 * @section page_copyright_xdg_system_bell_v1 Copyright
 * <pre>
 *
 * Copyright © 2016, 2023 Red Hat
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_surface;
struct xdg_system_bell_v1;

#ifndef XDG_SYSTEM_BELL_V1_INTERFACE
#define XDG_SYSTEM_BELL_V1_INTERFACE
/**
 * @page page_iface_xdg_system_bell_v1 xdg_system_bell_v1
 * @section page_iface_xdg_system_bell_v1_desc Description
 *
 * This global interface enables clients to ring the system bell.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 * @section page_iface_xdg_system_bell_v1_api API
 * See @ref iface_xdg_system_bell_v1.
 */
/**
 * @defgroup iface_xdg_system_bell_v1 The xdg_system_bell_v1 interface
 *
 * This global interface enables clients to ring the system bell.
 *
 * Warning! The protocol described in this file is currently in the testing
 * phase. Backward compatible changes may be added together with the
 * corresponding interface version bump. Backward incompatible changes can
 * only be done by creating a new major version of the extension.
 */
extern const struct wl_interface xdg_system_bell_v1_interface;
#endif

#define XDG_SYSTEM_BELL_V1_DESTROY 0
#define XDG_SYSTEM_BELL_V1_RING 1


/**
 * @ingroup iface_xdg_system_bell_v1
 */
#define XDG_SYSTEM_BELL_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_xdg_system_bell_v1
 */
#define XDG_SYSTEM_BELL_V1_RING_SINCE_VERSION 1

/** @ingroup iface_xdg_system_bell_v1 */
static inline void
xdg_system_bell_v1_set_user_data(struct xdg_system_bell_v1 *xdg_system_bell_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) xdg_system_bell_v1, user_data);
}

/** @ingroup iface_xdg_system_bell_v1 */
static inline void *
xdg_system_bell_v1_get_user_data(struct xdg_system_bell_v1 *xdg_system_bell_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) xdg_system_bell_v1);
}

static inline uint32_t
xdg_system_bell_v1_get_version(struct xdg_system_bell_v1 *xdg_system_bell_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) xdg_system_bell_v1);
}

/**
 * @ingroup iface_xdg_system_bell_v1
 *
 * Notify that the object will no longer be used.
 */
static inline void
xdg_system_bell_v1_destroy(struct xdg_system_bell_v1 *xdg_system_bell_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) xdg_system_bell_v1,
			 XDG_SYSTEM_BELL_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) xdg_system_bell_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_xdg_system_bell_v1
 *
 * This requests rings the system bell on behalf of a client. How ringing
 * the bell is implemented is up to the compositor. It may be an audible
 * sound, a visual feedback of some kind, or any other thing including
 * nothing.
 *
 * The passed surface should correspond to a toplevel like surface role,
 * or be null, meaning the client doesn't have a particular toplevel it
 * wants to associate the bell ringing with. See the xdg-shell protocol
 * extension for a toplevel like surface role.
 */
static inline void
xdg_system_bell_v1_ring(struct xdg_system_bell_v1 *xdg_system_bell_v1, struct wl_surface *surface)
{
	wl_proxy_marshal_flags((struct wl_proxy *) xdg_system_bell_v1,
			 XDG_SYSTEM_BELL_V1_RING, NULL, wl_proxy_get_version((struct wl_proxy *) xdg_system_bell_v1), 0, surface);
}

#ifdef  __cplusplus
}
#endif

#endif
