"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSemanticTokenLegends = getSemanticTokenLegends;
const vscode_languageserver_1 = require("vscode-languageserver");
function getSemanticTokenLegends() {
    const tokenModifiers = [];
    [
        [0 /* TokenModifier.declaration */, vscode_languageserver_1.SemanticTokenModifiers.declaration],
        [1 /* TokenModifier.static */, vscode_languageserver_1.SemanticTokenModifiers.static],
        [2 /* TokenModifier.async */, vscode_languageserver_1.SemanticTokenModifiers.async],
        [3 /* TokenModifier.readonly */, vscode_languageserver_1.SemanticTokenModifiers.readonly],
        [4 /* TokenModifier.defaultLibrary */, vscode_languageserver_1.SemanticTokenModifiers.defaultLibrary],
        [5 /* TokenModifier.local */, 'local']
    ].forEach(([tsModifier, legend]) => (tokenModifiers[tsModifier] = legend));
    const tokenTypes = [];
    [
        [0 /* TokenType.class */, vscode_languageserver_1.SemanticTokenTypes.class],
        [1 /* TokenType.enum */, vscode_languageserver_1.SemanticTokenTypes.enum],
        [2 /* TokenType.interface */, vscode_languageserver_1.SemanticTokenTypes.interface],
        [3 /* TokenType.namespace */, vscode_languageserver_1.SemanticTokenTypes.namespace],
        [4 /* TokenType.typeParameter */, vscode_languageserver_1.SemanticTokenTypes.typeParameter],
        [5 /* TokenType.type */, vscode_languageserver_1.SemanticTokenTypes.type],
        [6 /* TokenType.parameter */, vscode_languageserver_1.SemanticTokenTypes.parameter],
        [7 /* TokenType.variable */, vscode_languageserver_1.SemanticTokenTypes.variable],
        [8 /* TokenType.enumMember */, vscode_languageserver_1.SemanticTokenTypes.enumMember],
        [9 /* TokenType.property */, vscode_languageserver_1.SemanticTokenTypes.property],
        [10 /* TokenType.function */, vscode_languageserver_1.SemanticTokenTypes.function],
        // member is renamed to method in vscode codebase to match LSP default
        [11 /* TokenType.member */, vscode_languageserver_1.SemanticTokenTypes.method],
        [12 /* TokenType.event */, vscode_languageserver_1.SemanticTokenTypes.event]
    ].forEach(([tokenType, legend]) => (tokenTypes[tokenType] = legend));
    return {
        tokenModifiers,
        tokenTypes
    };
}
//# sourceMappingURL=semanticTokenLegend.js.map